SELECT TSystem.views__treporting__recreate();

--!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!                      SystemSettings            !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    SELECT tsystem.settings__set('HTTP-curl-ca-bundle-PATH', REPLACE(current_setting('data_directory'), 'data', 'ssl/certs/curl-ca-bundle.crt'));


    -- Dynamische Grundeinstellungen
    -- Alle Assistenten im Standard aktiv
    SELECT tsystem.settings__set( 'chkAssisVertrieb',     true );
    SELECT tsystem.settings__set( 'chkAssisEinkauf',      true );
    SELECT tsystem.settings__set( 'chkAssisWawi',         true );
    SELECT tsystem.settings__set( 'chkAssisFaktura',      true );
    SELECT tsystem.settings__set( 'chkAssisControlling',  true );
    SELECT tsystem.settings__set( 'chkAssisProjekt',      true );
    SELECT tsystem.settings__set( 'chkAssisFertigung',    true );
    SELECT tsystem.settings__set( 'chkAssisQuali',        true );
    SELECT tsystem.settings__set( 'chkAssisLager',        true );
    SELECT tsystem.settings__set( 'chkAssisPEM',          true );
    SELECT tsystem.settings__set( 'chkAssisService',      true );
    SELECT TSystem.Settings__set( 'MailSendMethod',       5);     --'Standard-Programm für .eml Dateien verwenden'


    SELECT TSystem.Settings__set( 'ad_landisovorgabe',    'DE');  -- Wichtig für E-Rechnung! Weiterhin NOT NULL

    /*bevorzugte Sprache*/
    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('Lang','','D');
    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('LangC','','0');
    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('BEWERLAGZU','',0);/*Bewertung Lagerzugang nicht zwingend erforderlich*/
    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('max_epreis_note','',9);/*keine Warnung bei Lieferantenauswahl im Einkauf weil Note ganz schlecht*/

    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('AUTOLAGZUDOKU','',1);/*beim Lagerzugang automatisch Wareneingangsdokument*/
    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('ASKAUTOLAGZUDOKU','',1);/*beim Lagerzugang automatisch Wareneingangsdokument, frage stellen*/
    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('NachtZVon','','23:00:00');/*Anfangszeit für Nachtzuschlag*/
    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('NachtZBis','','04:00:00');/*Endezeit für Nachtzuschlag*/
    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('Bde_MaschAusf_KS', '', 1);--Maschinenausfälle sind Kostenstellengebunden
    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('ZeitnachtragABKFokusieren','',1); -- Versteckt, nicht in Systemeinstellungen sichtbar, Default=TRUE
                                                                                    -- TFormBDEEndAuftg: Bei Zeitnachtrag mit ABK-Index einsteigen statt Prj.Nummer

    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('ERBuchenSetztGeprueft', '',1);

    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('AGK', '', 15);--Standard 15% Auwswärtsgemeinkosten
    --INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('MGK', '', 15);--Standard 15% Material
    --INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('FGK', '', 15);--Standard 15% Fertigung

    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('NK_AGK', '', 15);--Standard 15% Auwswärtsgemeinkosten
    --INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('NK_MGK', '', 15);--Standard 15% Material
    --INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('NK_FGK', '', 15);--Standard 15% Fertigung

    /*Settings ob Gesamtrabatte für Einkauf/Verkauf aktiviert werden sollen oder nicht*/
    INSERT INTO settings(s_Vari, s_owner, s_inha) VALUES ('UseBestRabatt','','0');
    INSERT INTO settings(s_Vari, s_owner, s_inha) VALUES ('UseVerkRabatt','','0');
    SELECT TSystem.Settings__Set('ld_auftg=ag_nr_add_pos', 'T'); -- Interner PA = VerkaufsNummer / Pos

    /*Preis im Einkauf wird normalerweise vorgeschlagen*/
    -- [?Obsolet?] INSERT INTO settings(s_Vari, s_owner, s_inha) VALUES ('epreisVorschlagen','','1');
    INSERT INTO settings(s_Vari, s_owner, s_inha) VALUES ('EINGRECH_SELBSTKO','','1');

    -- Einkauf, Schrittweite Positionsnummernvorschlag
    SELECT TSystem.Settings__Set('LD_POS_WIDTH', '10');

    INSERT INTO settings(s_vari, s_inha) VALUES ('bzUseAuftTxt', '1');

    -- Einkauf, Auftragsbezug der Banf.Pos. NICHT aus Banf.-Nr. vorfüllen
    SELECT TSystem.Settings__Set('BestAnf_SetzeKeineAuftragsnummer', TRUE);

    -- Lagerabgänge auf gleiche Auftragsposition zusammenfassen
    SELECT TSystem.Settings__Set('MergeLagAbg', True);

    -- Projekt-Adressen werden automatisch vom 1. zugehörigen Auftrag bzw. Angebot gefüllt.
    SELECT TSystem.Settings__Set( 'anl_addresses__set__by__auftg', true );

    -- Negative Lagerbestände unterbinden (kein 'ins Minus buchen')
    SELECT TSystem.Settings__Set('no_neg_lag', True);

    --Anzahl Nachkommastellen in Standardanzeige
    SELECT TSystem.Settings__Set('NKStellen', '2');

    --Vorgabe Auswärtsarbeitspaket
    SELECT TSystem.Settings__Set('AUSWAVORVORGABE', 'AW.EXTERN');

    --ASK standard mit Grenz und Normkosten
    SELECT TSystem.Settings__Set('AUSWAVORVORGABE', 'AW.EXTERN');

    -- Warenausgangsdatum vom Lieferschein setzen, wenn Rechnung definitiv wird. Ansonsten manuell.
    SELECT TSystem.Settings__Set('LieferscheinWADatumPerDefinitivRechnung', 'T'); -- belegpos.belp_termin, siehe belkopf__a_u

    -- Vorgabe sinnvolle Liefertoleranzen, siehe Einstellungen/Adressverwaltung
    SELECT TSystem.Settings__Set('adk1tolfrueh', '2'), TSystem.Settings__Set('adk1tolspaet', '1'),
           TSystem.Settings__Set('adk2tolfrueh', '1'), TSystem.Settings__Set('adk2tolspaet', '3');

    -- Einschränkung der Bearbeitung der Karenzen auf Personaler und Abteilungsleiter (Überstundenfreigabe)
    /*  Bis auf Weiteres deaktiviert, da Anpassung #11733 und nie praktisch im Einsatz gewesen
    in #11733 Entscheidung, dass Abteilungsleiter ihre eigenen Zeit bearbeiten dürfen
    SELECT TSystem.Settings__Set('Praesenzzeit.Personaler.Abteilungsleiter', false); */

    -- Nach dem Erstellen einer DB erstmal diese Funktion erlauben
    SELECT TSystem.Settings__Set('AdminLoginAllowed', True);
    SELECT TSystem.Settings__Set('IsDevelopSystem', False);

    -- Angebotsannahme automatisiert (gleicher Artikel und Kunde) // auftg__b_iu
    SELECT TSystem.Settings__Set('LinkAngAuftr', True);

    -- Wenn ein Artikel angelegt wird, muß Zuständig für Artikel eingetragen werden (Login)
    SELECT TSystem.Settings__Set('ArtZustOnInsert', True);

    -- #5766
    SELECT TSystem.Settings__Set('Zdok.Active', True);

    -- https://redmine.prodat-sql.de/issues/15323
    SELECT tsystem.settings__set( 'SkipBestOn_AkVerfueg', true );

    -- Abrufmenge u. Los automatisch reduzieren, wenn EK-Rahmen nicht mehr genug Menge offen hat
    SELECT TSystem.Settings__Set('EKRahmenRestAbrufen', True);
    -- EK-Rahmen auch dann noch zum Abruf vorschlagen, wenn das Gültigkeitsdatum überschritten ist (Wenn noch nicht erledigt)
    SELECT TSystem.Settings__Set('EKRahmenNachAblauf', True);

    SELECT TSystem.Settings__Set('ad_such', True);

    -- Vorgabe für PrintSettings die beim Kopieren ignoriert werden sollten
    SELECT TSystem.Settings__Set('PrintSettings_ignore_when_copying', 'psPageBreak,psSubTotal');

    --Debitoren und Kreditorenkonto
    INSERT INTO settings (s_vari,s_inha) VALUES ('debi_von','10000');
    INSERT INTO settings (s_vari,s_inha) VALUES ('debi_bis','69999');

    INSERT INTO settings (s_vari,s_inha) VALUES ('kredi_von','70000');
    INSERT INTO settings (s_vari,s_inha) VALUES ('kredi_bis','99999');

    --werkstattplanung
    INSERT INTO SETTINGS (s_vari, s_inha) VALUES ('WKST-PLAN', 1);--Werkstattplanung ist default TODO WEG?? Reine DLZ Terminierung!
    INSERT INTO SETTINGS (s_vari, s_inha) VALUES ('SIMPLE_ASK', 1);--einfach ASK ist default TODO WEG?
    INSERT INTO SETTINGS (s_vari, s_inha) VALUES ('CheckWkstPlanTermAutoPlan', 1);--Aufträge automatisch terminieren ist default
    INSERT INTO SETTINGS (s_vari, s_inha) VALUES ('DelNeueABK', 1);--neue Aufträge nach einem Tag entfernen ist default
    INSERT INTO SETTINGS (s_vari, s_inha) VALUES ('ChkTerminiBreakDateInPast', 1);--Terminierung abbrechen wenn Datum in Vergangenheit

    -- Freigabe Lager bei ABK erstellung (Produktionsauftrag) automatisch
    SELECT tsystem.settings__set( 'abk_ab_dolager_autofreigabe', true );

    -- Freigabe Einkauf bei ABK erstellung (Produktionsauftrag) automatisch #13894
    -- Hintergrund: es wird zu viel vergessen, mann kann den Freigabestatus auch manuell entfernen und explizit damit sperren.
    SELECT tsystem.settings__set( 'abk_ab_doeinkauf_autofreigabe', true );

    /* Setting : Staffelpreise in Angebot #19207 */
    SELECT TSystem.Settings__Set('auftgstp__auto__angebot', True);

    SELECT TSystem.Settings__Set('chkAGtermAuto', 't'); -- Standardverhalten bisher

    SELECT TSystem.Settings__Set('PT_ldsdoki__from__auftg__substdays', 1);  -- #11951 Tage differenz: Verkauf zu Produktionsauftrag

    INSERT INTO SETTINGS (s_vari, s_inha) VALUES ('Lager_Bestellbezugsverlustwarnung', 1);--http://redmine.prodat-sql.de/issues/4500

    --Betriebsjubiläum
    SELECT TSystem.Settings__Set('MSG.Daten.Jubilee', '5;10;25;40');
    SELECT Tsystem.Settings__Set( 'SET_LL_URLAUBGES', true );

    --Versandort für Dokumente
    SELECT TSystem.Settings__Set('DokVersandOrt_V', '#');

    -- # 16374 Standard für Mitarbeiter-Login (ll_db_usename) / Standard für Adresskurzname (Personal)
    SELECT TSystem.Settings__Set('BDE_DEFAULTVAL_ADDRKRZL',       'Kurzname [2 Nachname, 1 Vorname]');
    SELECT TSystem.Settings__Set('BDE_DEFAULTVAL__LL_DB_USENAME', 'Adresskurzname'); -- [Adresskurzname | Mitarbeiternummer]
--

/*Sprachen vordefinieren*/
    INSERT INTO sprach VALUES ('F');
    INSERT INTO sprach VALUES ('D');
    INSERT INTO sprach VALUES ('EN');
    INSERT INTO sprach VALUES ('IT');
    INSERT INTO sprach VALUES ('ES');
    INSERT INTO sprach VALUES ('CZ');
    INSERT INTO sprach VALUES ('RU');

    -- INSERT INTO sprach SELECT 'D/ES'; -- für Zweisprachige Übersetzungen
    -- INSERT INTO sprach SELECT 'D/RU';

    -- INSERT INTO adkspco SELECT 50, 'D/ES', 16255;
    -- INSERT INTO adkspco SELECT 70, 'D/RU', 16256;

    INSERT INTO adkspco (s_spco, s_spr_key, s_sprach) VALUES(0,'D', 4085);
    INSERT INTO adkspco (s_spco, s_spr_key, s_sprach) VALUES(1,'F', 4084);
    --2 = frei
    INSERT INTO adkspco (s_spco, s_spr_key, s_sprach) VALUES(3,'EN', 4086);
    INSERT INTO adkspco (s_spco, s_spr_key, s_sprach) VALUES(4,'IT', 11190);
    INSERT INTO adkspco (s_spco, s_spr_key, s_sprach) VALUES(5,'ES', 11191);
    INSERT INTO adkspco (s_spco, s_spr_key, s_sprach) VALUES(6,'CZ', 11192);
    INSERT INTO adkspco (s_spco, s_spr_key, s_sprach) VALUES(7,'RU', 11193);
--
/*Zeiteinheiten*/
    INSERT INTO zeinh (z_id, z_einh, z_iso, z_uf) VALUES (1, 739,  'h'  ,  3600);/*Stunden*/
    INSERT INTO zeinh (z_id, z_einh, z_iso, z_uf) VALUES (2, 565,  'min',    60);/*Minuten*/
    INSERT INTO zeinh (z_id, z_einh, z_iso, z_uf) VALUES (3, 3007, 'sec',     1);/*Sekunden*/
    INSERT INTO zeinh (z_id, z_einh, z_iso, z_uf) VALUES (4, 749, 'd', 28800);/*Tage=8 Stunden*/ -- LOL?!!!11111ELF
    -- INSERT INTO zeinh (z_id, z_einh, z_iso, z_uf) VALUES (4, 12710,  'd', 28800);/*Arbeitstage=8 Stunden*/ -- LOL?!!!11111ELF
    -- INSERT INTO zeinh (z_id, z_einh, z_iso, z_uf) VALUES (5, 749,    'd', 86400);/*Tage=24 Stunden*/  -- aus DBUpdate "Zeiteinheiten Tage=>Arb.Tag" ("2012-09-05 17:30:19")

--
-- Steutxt
    SELECT TSystem.trigger__disable( 'steutxt' );
    /*
    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt, steu_valid_from, steu_valid_to) VALUES (-1, NULL, 0, NULL, 'systemintern', 'Umsatzsteuer', current_date-1, current_date-1);
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (-1, 'D', 'Umsatzsteuer');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (-1, 'EN', 'Sales tax');
    */

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (1, NULL, 0, '4110', NULL, 'Steuerfrei Inland');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (1, 'D', 'Steuerfrei Inland');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (1, 'EN', 'tax-free');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (2, 0, 0, '4125', NULL, 'Umsatzsteuerfrei EU');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (2, 'D', 'Steuerfrei EU');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (2, 'EN', 'tax-free EU');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (3, 3, 19, '4400', NULL, 'Umsatzsteuer 19%');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (3, 'D', 'Umsatzsteuer 19%');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (4, 0, 0, '4120', NULL, 'Umsatzsteuerfrei nicht EU');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (4, 'D', 'steuerfrei nicht EU');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (4, 'EN', 'tax-free non-EU');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (8, NULL, 7, '1401', NULL, 'Vorsteuer 7%');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (8, 'D', 'Vorsteuer 7%');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (9, NULL, 19, '1406', NULL, 'Vorsteuer 19%');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (9, 'D', 'Vorsteuer 19%');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (59, 0, 0, '5909', NULL, 'Vorsteuerfrei EU');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (59, 'D', 'Vorsteuerfrei EU');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (51, NULL, 10, '1442', NULL, 'Vorsteuer 10% Italien');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (51, 'D', 'Vorsteuer 10% Italien');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (50, NULL, 20, '1442', NULL, 'Vorsteuer 20% Italien');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (50, 'D', 'Vorsteuer 20% Italien');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (30, 0, 20, '4321', NULL, 'Umsatzsteuer 20% Italien');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (30, 'D', 'Umsatzsteuer 20% Italien');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (58, 0, 10, '1440', NULL, 'Vorsteuer 10% Spanien');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (58, 'D', 'Vorsteuer 10% Spanien');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (57, NULL, 20, '1440', NULL, 'Vorsteuer 20% Spanien');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (57, 'D', 'Vorsteuer 20% Spanien');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (40, 0, 20, '4320', NULL, 'Umsatzsteuer 20% Spanien');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (40, 'D', 'Umsatzsteuer 20% Spanien');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (55, NULL, 10, '1441', NULL, 'Vorsteuer 10% Tschechien');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (55, 'D', 'Vorsteuer 10% Tschechien');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (54, NULL, 20, '1441', NULL, 'Vorsteuer 20% Tschechien');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (54, 'D', 'Vorsteuer 20% Tschechien');

    INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (26, 0, 20, '4322', NULL, 'Umsatzsteuer 20% Tschechien');
    INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (26, 'D', 'Umsatzsteuer 20% Tschechien');

    --INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (25, 0, 19, NULL, NULL, 'Umsatzsteuer 19 % Tschechien');
    --INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (2, NULL, 16, NULL, NULL, 'Umsatzsteuer 16%');
    --INSERT INTO steutxt (steu_z, steu_grup, steu_proz, steu_konto, steu_allg1, steu_txt) VALUES (5, NULL, 16, NULL, NULL, 'Vorsteuer 16 %');
    --INSERT INTO steutxt (steu_z, steu_proz, steu_txt, steu_konto) VALUES (2, 16, 'Mehrwertsteuer 16%', '8340');
    --INSERT INTO steutxtlang (sl_steu_z, sl_spr_key, sl_txt) VALUES (2, 'D', 'Mehrwertsteuer 16%');

    SELECT TSystem.trigger__enable( 'steutxt' );
--
--bewa
    INSERT INTO bewa (wa_einh, wa_bez, wa_kurs, wa_rund, wa_abkz) VALUES ('EUR', 'Euro', 1, 0.01, '€');
    INSERT INTO bewa (wa_einh, wa_bez, wa_kurs, wa_rund, wa_abkz) VALUES ('CHF', 'Schweizer Franken', 0.82, 0.05, 'CHF');
    INSERT INTO bewa (wa_einh, wa_bez, wa_kurs, wa_rund, wa_abkz) VALUES ('GBP', 'Pfund Sterling', 1.21, 0.01, '£');
--
--Abzuschläge
    SELECT TSystem.trigger__disable( 'abzu' );
    INSERT INTO abzu (abz_id, abz_txt, abz_type) VALUES (-1, 'Sonstige','E');
    INSERT INTO abzutxt (abzl_abz_id, abzl_spr_key, abzl_txt) VALUES (-1, 'D', 'Sonstige');
    INSERT INTO abzutxt (abzl_abz_id, abzl_spr_key, abzl_txt) VALUES (-1, 'EN', 'Others');

    INSERT INTO abzu (abz_id, abz_txt, abz_type) VALUES (1, 'Transportkosten','E');
    INSERT INTO abzutxt (abzl_abz_id, abzl_spr_key, abzl_txt) VALUES (1, 'D', 'Transportkosten');
    INSERT INTO abzutxt (abzl_abz_id, abzl_spr_key, abzl_txt) VALUES (1, 'EN', 'freight costs');

    INSERT INTO abzu (abz_id, abz_txt, abz_konto, abz_canskonto, abz_inselbstko, abz_type) VALUES (100, 'Kupferzuschlag', 5400, False, True, 'M');
    INSERT INTO abzutxt (abzl_abz_id, abzl_spr_key, abzl_txt) VALUES (100, 'D', 'Kupferzuschlag');
    INSERT INTO abzutxt (abzl_abz_id, abzl_spr_key, abzl_txt) VALUES (100, 'EN', 'CU-Addition');

    INSERT INTO abzu (abz_id, abz_txt, abz_type) VALUES (200, 'Anteiliger Belegzuschlag','E');
    INSERT INTO abzutxt (abzl_abz_id, abzl_spr_key, abzl_txt) VALUES (200, 'D', 'Anteiliger Belegzuschlag');

    INSERT INTO abzu (abz_id, abz_txt, abz_type) VALUES (300, 'Fixkosten Auswärtsbearbeitung','E');
    INSERT INTO abzutxt (abzl_abz_id, abzl_spr_key, abzl_txt) VALUES (300, 'D', 'Fixkosten Auswärtsbearbeitung');

    SELECT TSystem.trigger__enable( 'abzu' );

    SELECT setval('abzu_abz_id_seq', 2, false);
--

--
/*IC UND AC*/

    --Platzhalter
    INSERT INTO intcod VALUES (0,933);--Intern zB CHNR Kontrollmerkmale
    --
    INSERT INTO intcod VALUES (1,808);--Werkzeugteil
    INSERT INTO intcod VALUES (3,672);--Rohmaterial
    INSERT INTO intcod VALUES (4,4575);--Kaufteile
    INSERT INTO intcod VALUES (5,4078);--Sonderteil eingek. unbearbeitet
    INSERT INTO intcod VALUES (6,4079);--Verpackungsmittel
    INSERT INTO intcod VALUES (7,7503);--Elektronik
    INSERT INTO intcod VALUES (8,1465);--Elektromaterial
    INSERT INTO intcod VALUES (9,1466);--Chemieartikel
    --
    INSERT INTO intcod VALUES (10,4080);--Eigene Produkte
    --
    INSERT INTO intcod VALUES (25,1039);--Prüfmittel
    --
    INSERT INTO intcod VALUES (30,3303);--Mechanikmaterial
    --
    INSERT INTO intcod VALUES (50,2779);--Eigene Arbeitspakete
    INSERT INTO intcod VALUES (70,11131);--Serviceprodukte
    --
    --INSERT INTO intcod VALUES (99,1598);--Projektstrukturpläne
    --
    INSERT INTO intcod VALUES (100,1471);--Baustoffe
    INSERT INTO intcod VALUES (200,4076);--Maschinenpark, Apparate
    INSERT INTO intcod VALUES (210,796);--Vorrichtungen
    INSERT INTO intcod VALUES (500,450);--Inventar
    INSERT INTO intcod VALUES (999,3000);--Sonstiges
    --
    INSERT INTO intcod VALUES (600,15421);--Qualifikation
    --
    INSERT INTO intcod VALUES (700,11234);--Marketing / Öffentlichkeitsarbeit
    --
    --INSERT INTO intcod VALUES (15,852);--Zuschläge
    --INSERT INTO intcod VALUES (16,4081);--Zeitartikel


    SELECT TSystem.trigger__disable( 'artcod' );
    ALTER TABLE artcod ENABLE  TRIGGER artcod__b_iu__ac_i__standardme_stk;

    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('WE1001', 1, 'Werkzeuge');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('MA1001', 200, 'Maschinenpark, Apparate');
    INSERT INTO artcod(ac_n, ac_i, ac_b, ac_vkpfaktor, ac_me_code_stange3m) VALUES ('RM1001', 3, 'Rohmaterialien', 1.25, True);
    INSERT INTO artcod(ac_n, ac_i, ac_b, ac_vkpfaktor) VALUES ('KT1001', 4, 'Kaufteile', 1.25);
    INSERT INTO artcod(ac_n, ac_i, ac_b, ac_vkpfaktor) VALUES ('SO1001', 5, 'Kaufteile - Sondermaterial (zB Zuschnitte)', 1.35);
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('KT1010', 4, 'Kaufteile Büromaterial');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('VP1001', 6, 'Verpackungsmittel');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('EL1001', 7, 'Elektronik');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('EM1001', 8, 'Elektromaterial');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('CH1001', 9, 'Chemieartikel');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('PR1001', 10, 'Eigene Produkte');

    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('PM1001', 25, 'Prüfmittel Allg.');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('PM1002', 25, 'Prüfmittel Sonderanfertigung');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('PM1003', 25, 'Prüfmittel durch Kunde');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('ESL1001', 4, 'E-Shelf-Label');
    --
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('DL1001', 50, 'Eigene Arbeitspakete | Dienstleistungen');
    --INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('PSTR1001', 99, 'Projektstrukturpläne');
    --
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('BAU1001', 100, 'Baustoffe');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('S', 999, 'Sonstiges');
    --
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('QL-AA', 600, 'Ausbildung und Abschlüsse');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('QL-FS', 600, 'Fremdsprachen');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('QL-INTERN', 600, 'Schulungen Unternehmensspezifisch');
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('QL-KFZ', 600, 'Führerscheine');
    --
    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES
     ('DLEXT', 50, 'Externe Arbeitspakete und Dienstleistungen'),
     ('DLINT', 50, 'Interne Arbeitspakete und Dienstleistungen');

    INSERT INTO artcod(ac_n, ac_i, ac_b) VALUES ('CHNR-QS', 0, 'Kontrollmerkmale für Chargenpflichtige Artikel');
    --
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('WE1001', 'D', 'Werkzeuge');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('MA1001', 'D', 'Maschinenpark, Apparate');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('RM1001', 'D', 'Rohmaterialien');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('KT1001', 'D', 'Kaufteile');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('KT1010', 'D', 'Kaufteile Büromaterial');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('VP1001', 'D', 'Verpackungsmittel');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('EL1001', 'D', 'Elektronik');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('EM1001', 'D', 'Elektromaterial');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('CH1001', 'D', 'Chemieartikel');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('PR1001', 'D', 'Eigene Produkte');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('DL1001', 'D', 'Eigene Arbeitspakete');
    --INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('PSTR1001', 'D', 'Projektstrukturpläne');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('BAU1001', 'D', 'Baustoffe');
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES ('S', 'D', 'Sonstiges');
    --
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES
     ('QL-AA', 'D', 'Ausbildung und Abschlüsse'),
     ('QL-FS', 'D', 'Fremdsprachen'),
     ('QL-INTERN', 'D', 'Schulungen Unternehmensspezifisch'),
     ('QL-KFZ', 'D', 'Führerscheine');
    --
    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES
     ('DLEXT', 'D', 'Externe Arbeitspakete und Dienstleistungen'),
     ('DLINT', 'D', 'Interne Arbeitspakete und Dienstleistungen');

    INSERT INTO artcodlang(acl_ac_n, acl_spr_key, acl_txt) VALUES
     ('CHNR-QS', 'D', 'Kontrollmerkmale für Chargenpflichtige Artikel');


    SELECT TSystem.trigger__enable( 'artcod' );
--
/*Mengeneinheiten*/
    INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (1, 'Stk', 'Stück');
    INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (2, 'kg', 'Kilogramm');
    INSERT INTO mgcode (me_cod, me_iso, me_bez, me_dimnum) VALUES (3, 'mm', 'Millimeter', 1);
    INSERT INTO mgcode (me_cod, me_iso, me_bez, me_dimnum) VALUES (4, 'm', 'Meter', 1);
    INSERT INTO mgcode (me_cod, me_iso, me_bez, me_dim1, me_dimnum) VALUES (5, 'm²', 'Quadratmeter', 4, 2);
    INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (6, 'psch', 'Pauschal');
    INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (7, 'paar', 'Paar');
    INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (8, 'set', 'Set');
    INSERT INTO mgcode (me_cod, me_iso, me_bez, me_dim1, me_dimnum) VALUES ( 9, 'm³',  'Kubikmeter',        4, 3);
    INSERT INTO mgcode (me_cod, me_iso, me_bez, me_dim1, me_dimnum) VALUES (10, 'mm²', 'Quadratmillimeter', 3, 2);
    INSERT INTO mgcode (me_cod, me_iso, me_bez, me_dim1, me_dimnum) VALUES (11, 'mm³', 'Kubikmillimeter',   3, 3);

    INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (50, 'St 3m', 'Stange 3 Meter');
    INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (51, 'St 6m', 'Stange 6 Meter');

    INSERT INTO meconvert (mc_cod1, mc_cod2, mc_uf) VALUES (3, 4, 1000); --Umrechnung von Millimeter zu Meter und Quadratmeters
--

-- Kundenstatus
    INSERT INTO kstatus (kstatus, bezeich) VALUES ('I', 'In Akquise');
    INSERT INTO kstatus (kstatus, bezeich) VALUES ('1', 'Stammkunden');
    INSERT INTO kstatus (kstatus, bezeich) VALUES ('2', 'Neukunden');

--Systemschlüsselworte (alle anderen Kategorien werden synchronisiert)
INSERT INTO recnocommentkategorie(rck_id, rck_b, rck_gruppe) VALUES ('internal system usage', 'Interne Verwendung', 'System');

--Abteilungen für Dokumentenverwaltung (Vordefiniert)
    INSERT INTO dokabteilungen (dabt_name, dabt_tablename, dabt_pos) VALUES ('Posteingang', 'scaneingang', 0);
    INSERT INTO dokabteilungen (dabt_name, dabt_tablename, dabt_pos) VALUES ('Verkauf', 'verkauf', 10);
    INSERT INTO dokabteilungen (dabt_name, dabt_tablename, dabt_pos) VALUES ('Einkauf', 'einkauf', 20);
    INSERT INTO dokabteilungen (dabt_name, dabt_tablename, dabt_pos) VALUES ('Controlling', 'controlling', 30);
    INSERT INTO dokabteilungen (dabt_name, dabt_tablename, dabt_pos) VALUES ('Geschäftsführung', 'gf', 40);
    INSERT INTO dokabteilungen (dabt_name, dabt_tablename, dabt_pos) VALUES ('Lager', 'lager', 50);
    INSERT INTO dokabteilungen (dabt_name, dabt_tablename, dabt_pos) VALUES ('Qualität', 'qs', 60);
    INSERT INTO dokabteilungen (dabt_name, dabt_tablename, dabt_pos) VALUES ('IT&EDV', 'it', 70);

/*Rechnung als Belegart*/
--Sprachen
 --BelArt
    INSERT INTO belart (ba_id, ba_bez) VALUES (1, 'Rechnung');
    DELETE FROM belartlang WHERE bal_ba_id=1;
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (1, 'D', 'Rechnung');
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (1, 'EN', 'Invoice');

    INSERT INTO belart (ba_id, ba_bez) VALUES (2, 'Gutschrift');
    DELETE FROM belartlang WHERE bal_ba_id=2;
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (2, 'D', 'Gutschrift');
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (2, 'EN', 'Credit note');

    INSERT INTO belart (ba_id, ba_bez) VALUES (3, 'Proforma-Rechnung');
    DELETE FROM belartlang WHERE bal_ba_id=3;
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (3, 'D', 'Proforma-Rechnung');
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (3, 'EN', 'Pro forma invoice');

    INSERT INTO belart (ba_id, ba_bez) VALUES (4, 'Anzahlungsrechnung');
    DELETE FROM belartlang WHERE bal_ba_id=4;
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (4, 'D', 'Anzahlungsrechnung');
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (4, 'EN', 'Advance invoice');

    INSERT INTO belart (ba_id, ba_bez) VALUES (5, 'Aufmaß');
    DELETE FROM belartlang WHERE bal_ba_id=5;
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (5, 'D', 'Aufmaß');
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (5, 'EN', 'Allowance');

    INSERT INTO belart (ba_id, ba_bez) VALUES (6, 'Abschlagsrechnung kumuliert');
    DELETE FROM belartlang WHERE bal_ba_id=6;
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (6, 'D', 'Abschlagsrechnung kumuliert');

    INSERT INTO belart (ba_id, ba_bez) VALUES (7, 'Abschlagsrechnung');
    DELETE FROM belartlang WHERE bal_ba_id=7;
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (7, 'D', 'Abschlagsrechnung');
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (7, 'EN', 'Progress payment invoice');

    INSERT INTO belart (ba_id, ba_bez) VALUES (10, 'Schlussrechnung');
    DELETE FROM belartlang WHERE bal_ba_id=10;
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (10, 'D', 'Schlussrechnung');
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (10, 'EN', 'Final invoice');

    INSERT INTO belart (ba_id, ba_bez) VALUES (11, 'Storno-Rechnung');
    DELETE FROM belartlang WHERE bal_ba_id=11;
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (11, 'D', 'Storno-Rechnung');

    INSERT INTO belart (ba_id, ba_bez) VALUES (12, 'Rechnungskorrektur');
    DELETE FROM belartlang WHERE bal_ba_id=12;
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (12, 'D', 'Rechnungskorrektur');
    INSERT INTO belartlang (bal_ba_id, bal_spr_key, bal_txt) VALUES (12, 'EN', 'Invoice correction');


    SELECT setval('belart_ba_id_seq', 100, false);

 /*Belegarten für neue Belegstruktur*/

    INSERT INTO belegtyp (belt_typ, belt_bezeichnung, belt_multipledok, belt_eingangsseitig, belt_ausgangsseitig, belt_zahlfaehig, belt_preiscalc) VALUES ('B',  'Beleg',             FALSE,FALSE,FALSE,FALSE,FALSE);
    INSERT INTO belegtyp (belt_typ, belt_bezeichnung, belt_multipledok, belt_eingangsseitig, belt_ausgangsseitig, belt_zahlfaehig, belt_preiscalc) VALUES ('ERG','Eingangsrechnung',  FALSE,TRUE, FALSE,TRUE, TRUE );
    INSERT INTO belegtyp (belt_typ, belt_bezeichnung, belt_multipledok, belt_eingangsseitig, belt_ausgangsseitig, belt_zahlfaehig, belt_preiscalc) VALUES ('LFS','Lieferschein',      FALSE,FALSE,TRUE, FALSE,FALSE);
    INSERT INTO belegtyp (belt_typ, belt_bezeichnung, belt_multipledok, belt_eingangsseitig, belt_ausgangsseitig, belt_zahlfaehig, belt_preiscalc) VALUES ('LUE','Ursprungserklärung',FALSE,FALSE,FALSE,FALSE,FALSE);

    INSERT INTO belegart (bela_id, bela_beld_typ, bela_bez) VALUES (1, 'ERG', 'Eingangsrechnung');
    DELETE FROM belegartlang WHERE belal_bela_id=1;
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (1, 'D', 'Eingangsrechnung');
    --
    INSERT INTO belegart (bela_id, bela_beld_typ, bela_bez) VALUES (2, 'ERG', 'Gutschrift');
    DELETE FROM belegartlang WHERE belal_bela_id=2;
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (2, 'D', 'Gutschrift');
    --
    INSERT INTO belegart (bela_id, bela_beld_typ, bela_bez) VALUES (20, 'ERG', 'Anzahlung / Vorkasse');
    DELETE FROM belegartlang WHERE belal_bela_id=20;
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (20, 'D', 'Anzahlung / Vorkasse');
    --
    INSERT INTO belegart (bela_id, bela_beld_typ, bela_bez) VALUES (3, 'LFS', 'Lieferschein');
    DELETE FROM belegartlang WHERE belal_bela_id=3;
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (3, 'D', 'Lieferschein');
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (3, 'EN', 'Delivery Note');
    --
    INSERT INTO belegart (bela_id, bela_beld_typ, bela_bez) VALUES (4, 'LFS', 'Retourenlieferschein');
    DELETE FROM belegartlang WHERE belal_bela_id=4;
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (4, 'D', 'Retourenlieferschein');
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (4, 'EN','Return Delivery Note');
    --
    INSERT INTO belegart (bela_id, bela_beld_typ, bela_bez) VALUES (5, 'LUE', 'Lieferanten-Ursprungserklärung');
    DELETE FROM belegartlang WHERE belal_bela_id=5;
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (5, 'D', 'Lieferanten-Ursprungserklärung');
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (5, 'F', 'Déclaration du fournisseur d''origine');
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (5, 'EN', 'Supplier''s declaration of origin');
    -- Lieferschein für Beistellmaterial
    INSERT INTO belegart (bela_id, bela_beld_typ, bela_bez) VALUES (6, 'LFS', 'Beistell-Lieferschein');
    DELETE FROM belegartlang WHERE belal_bela_id=6;
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (6, 'D', 'Beistell-Lieferschein');
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (6, 'EN','Consignment Receipt');
    -- Stornolieferschein
    INSERT INTO belegart (bela_id, bela_beld_typ, bela_bez) VALUES (10, 'LFS', 'Stornolieferschein');
    DELETE FROM belegartlang WHERE belal_bela_id=10;
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (10, 'D', 'Stornolieferschein');
    INSERT INTO belegartlang (belal_bela_id, belal_spr_key, belal_txt) VALUES (10, 'EN','Cancelation delivery note');

    --
    SELECT TSystem.Settings__ENUM__Set('TCustomBelegModul.Art.DokuLinkTypes',  'LUE', True);  -- DokuLink-Trigger für diesen Belegtyp aktivieren
    SELECT TSystem.Settings__ENUM__Set('TCustomBelegModul.AdkL.DokuLinkTypes', 'LUE', True);

-- Lager UE (Unvollendete Artikel im Lager)
INSERT INTO lagerbereich (lgb_name, lgb_descr, lgb_zutxt) VALUES ('UE', 'Unvollendete Artikel: eingelagert im Produktionsprozess',
                                                                                'Artikel, welche während des Fertigungsprozess halbfertig eingelagert werden.'
                                                                      ||E'\n'|| 'Die Artikel enthalten automatisch in der Chargennummer den Arbeitsgang, mit welchem diese eingelagert werden (sollte der letzte vollständige sein).'
                                                                      ||E'\n'|| 'Modul: Lager UE'
                                                                  );


--
/*AVOR: Kalkulationsstaffel, OPLStat etc*/
    INSERT INTO op7_template(o7t_m, o7t_korr) VALUES (1, 1);
    INSERT INTO op7_template(o7t_m, o7t_korr) VALUES (50, 0.9);
    INSERT INTO op7_template(o7t_m, o7t_korr) VALUES (100, 0.8);
    INSERT INTO op7_template(o7t_m, o7t_korr) VALUES (500, 0.7);
    INSERT INTO op7_template(o7t_m, o7t_korr) VALUES (1000, 0.6);

    INSERT INTO oplstat (os_stat, os_bez) VALUES ('E', 'Erstbemusterung');
    INSERT INTO oplstat (os_stat, os_bez) VALUES ('F', 'Freigabe liegt vor');
    INSERT INTO oplstat (os_stat, os_bez) VALUES ('N', 'Nachprüfung');
    INSERT INTO oplstat (os_stat, os_bez) VALUES ('X', 'Gesperrt, Freigabe fehlt');


    INSERT INTO op6mstat (o6m_stat, o6m_bz) VALUES (0, 'Pro Stück');
    INSERT INTO op6mstat (o6m_stat, o6m_bz) VALUES (1, 'Pro Los');
    --INSERT INTO op6mstat (o6m_stat, o6m_bz) VALUES (2, 'Pro Fertigungsauftrag');
 --

-- Stücklisten-Typen gemäß der Anwendungsfälle
  -- vgl. 16295
INSERT INTO stv_typ
  ( stt_ident,  stt_bez )
VALUES
  ( 'BGr-STD',  'Standard-Baugruppe, gewöhnliches Produkt' ),
  ( 'BL',       'Beistellung an Lieferanten' ),
  ( 'PS',       'Produktions-Set' )
;
--

-- Stücklisten-Typ-Validierung gemäß der Zuständen zu den Anwendungsfällen
  -- vgl. #16299
INSERT INTO tvalidation.stv_typ__subroutine
      (
          sttvld_typ, sttvld_order, sttvld_subroutine,
          sttvld_options
      )
VALUES
  -- Beistellung an Lieferanten:
      -- IC der Wurzel
      (
          'BL',       1,            'stv_typ__wurzel__intcod',
          jsonb_build_object(
              '_expected_values',
              -- erlaubt sind
              jsonb_build_array( 4 )
          )
      ),
      -- Stat P. der inneren Knoten
      (
          'BL',       2,            'stv_typ__innere_knoten__st_stat',
          jsonb_build_object(
              '_expected_values',
              -- erlaubt sind
              jsonb_build_array( 'BK', 'BL', 'KS' )
          )
      ),

  -- Standard-Baugruppe, gewöhnliches Produkt:
      -- IC der Wurzel
      (
          'BGr-STD',  1,            'stv_typ__wurzel__intcod',
          jsonb_build_object(
              '_expected_values',
              -- erlaubt sind
              jsonb_build_array( 10 )
          )
      ),
      -- Stat P. der inneren Knoten
      (
          'BGr-STD',  2,            'stv_typ__innere_knoten__st_stat',
          jsonb_build_object(
              '_expected_values',
              -- erlaubt sind (nicht BL)
              jsonb_build_array( 'BK', 'KS', 'AM', null )
          )
      )
;
--

 /*Vorschläge für Betriebskennzahlen Kostenrechnung*/

 INSERT INTO kostrechgemko (krc_bez) VALUES ('Verwaltungsgemeinkosten');
 INSERT INTO kostrechgemko (krc_bez) VALUES ('Vertriebsgemeinkosten');
 INSERT INTO kostrechgemko (krc_bez) VALUES ('Forschung & Entwicklung');

 SELECT TSystem.Settings__Set('BGKOST_ASKKALKVAR', 'T');
 SELECT TSystem.Settings__Set('BGKOST_LOSGR', 'T');
 SELECT TSystem.Settings__Set('BGCALC_EPREIS_STAFF', 'T');

 SELECT TSystem.Settings__Set('BDE_RP', True); /* #6689 Raucherpause standardmäßig aktiv */
 SELECT TSystem.Settings__Set('BDERuestZeit', True);
 SELECT TSystem.Settings__Set('BDE_TEILERM_ALLWAYS_ACTIVE', True); -- #7654 Rüstzeit mit enthaltener Auftragszeit stempeln benötigt Rückmelde-Oberfläche. Bei Neuinstallation aktiv.
 SELECT TSystem.Settings__Set('BDEAutoLogout_Option', 1);           -- #11527 BDE: Auto Logout 30sec

 /* BDE Rechte*/
 SELECT TSystem.Settings__Set('BDE_bdep_abteilungsleiter_rights', 1);

 -- Datum, ab wann die Berechnung des individ. Werktags gültig ist, siehe #14870
 -- Default bei Neuinstallationen: immer gültig
 -- Verwendung in Tpersonal.bdep__individwt__get_date__by_bd_anf_minr
 SELECT TSystem.Settings__Set('individwt_valid_from_date', '-infinity');

/*Bde - Abwesenheitsgründe*/

 -- ID 001-149  statische Systemvorgaben
 --    150-174  änderbare Systemvorgaben
 --    175-...  Kundendaten
 -- DefaultColors des Editor-DropDowns siehe TFormAbw.GridAbwGrundab_color2PropertiesGetCustomColorSet
 --   CimGreen CimRed CimDarkRed CimOrange CimDarkOrange CimYellow CimLightBlue   clLime clGreen clYellow
 --   DEFAULT = x'F0CAA6'::int  -- CimBlue
 INSERT INTO bdeabgruende
   (ab_id, ab_txt,         ab_txt_short,  ab_type,              ab_vhz, ab_show, ab_terminal, ab_antrag, ab_color) VALUES
   (1,     'Urlaub',                'U',  'Urlaub',             FALSE,  TRUE,    TRUE,        TRUE,      x'83CF8A'::INTEGER), --CimGreen
   (2,     'Krank',                 'K',  'Krank',              TRUE,   TRUE,    TRUE,        TRUE,      x'A6B6F7'::INTEGER), --CimRed
   --(3,   'Stundenauszahlung',     'SA', null,                 TRUE,   TRUE,    TRUE,      NULL,   DEFAULT),  -- ALT


   (100,   'Urlaub 1/2',            'U',  'Urlaub',             FALSE,  TRUE,    TRUE,        TRUE,      x'83CF8A'::INTEGER),
   (101,   'Mindestpause',          'MP', 'Pause',              TRUE,   FALSE,   FALSE,       FALSE,     DEFAULT),
   (102,   'Kurzarbeit 1/2',        'KA', 'Kurzarbeit',         FALSE,  TRUE,    FALSE,       FALSE,     DEFAULT),
   (103,   'Raucherpause',          'RP', 'PauseRaucher',       FALSE,  FALSE,   TRUE,        FALSE,     DEFAULT),
   (104,   'Schule',                'SU', 'Schulung',           FALSE,  TRUE,    TRUE,        TRUE,      DEFAULT),  -- (ab_autobewill=true)
   --(105, 'Sonderurlaub',          'SU', null,                 False,  True,    True,      NULL,   DEFAULT),  -- TEST Markus 03.2016?
   --(106, 'Unbezahlt',             'UB', null,                 False,  False,   True,      NULL,   DEFAULT),  -- TEST Markus 03.2016?
   --(107, 'Unbekannt',             '?',  null,                 False,  False,   True,      NULL,   DEFAULT),  -- TEST Markus 03.2016?
   (108,   'Schulungsmaßnahmen',    'SM', 'Schulung',           FALSE,  TRUE,    TRUE,        False,     DEFAULT),  -- skillplan für Urlaubsplantafel
   (110,   'Pause',                 'AP', 'Pause',              FALSE,  FALSE,   TRUE,        FALSE,     DEFAULT),
   (111,   'Abwesend Terminal',     'AT', 'PauseTerminal',      FALSE,  FALSE,   TRUE,        FALSE,     DEFAULT),
   (112,   'Kurzarbeit',            'KA', 'Kurzarbeit',         FALSE,  TRUE,    FALSE,       FALSE,     DEFAULT),
   (150,   'Stundenausgleich',      'S',  'StundenAusgleich',   FALSE,  TRUE,    FALSE,       TRUE,      DEFAULT)
   --(152, 'Zeitausgleich',         'Z',  'StundenAusgleich',   False,  True,    True,      NULL,   DEFAULT),  -- TEST Markus 08.2016?
   --(154, 'Auszahlung',            'A',  null,                 False,  False,   True,      NULL,   DEFAULT),  -- TEST Markus 08.2016?
   --(157,   'Dienstreise',           'DF', 'Dienstgang',         False,  True,    True,        NULL,      DEFAULT), TODO neuer Untertyp, da KEINE Uhrzeiten => ganztags
   ;

INSERT INTO bdeabgruende
   (ab_id, ab_txt,         ab_txt_short,  ab_type,              ab_duplicate_allowed, ab_show, ab_terminal, ab_antrag, ab_autobewill, ab_stu_from_time, ab_stu_abzu, ab_color) VALUES
   (156,   'Dienstgang',   'D',           'Dienstgang',         true,                 True,    True,        true,      true,          true,             1,           DEFAULT),
   (160,   'Arztgang',     'KA',          'Dienstgang',         true,                 True,    True,        true,      true,          true,             1,           DEFAULT)
   ;

 --
 SELECT setval('"public"."bdeabgruende_ab_id_seq"', 175, false);

 -- Vorgaben: Produktions-Ausfallgründe
 INSERT INTO bdeausgruende (aus_id, aus_txt) VALUES (1, 'Werkzeug fehlt');
 INSERT INTO bdeausgruende (aus_id, aus_txt) VALUES (2, 'Elektroschaden');
 INSERT INTO bdeausgruende (aus_id, aus_txt) VALUES (3, 'Mechanikschaden');
 INSERT INTO bdeausgruende (aus_id, aus_txt) VALUES (103, 'Raucherpause');
 INSERT INTO bdeausgruende (aus_id, aus_txt) VALUES (110, 'Pause');
 SELECT setval('bdeausgruende_aus_id_seq', 150, false);

 SELECT TSystem.Settings__Set('BDEAusfallStemp', 'T');

 -- Vorgaben: Produktions-Ausschussgründe
 INSERT INTO bdea_ausschussgruende(asg_descr) VALUES
        ('Bedienerfehler'),
        ('Falsch gespannt'),
        ('Fertigungsablauf / Technologie'),
        ('Maschinengenauigkeit'),
        ('Material'),
        ('Messfehler'),
        ('Nullpunktfehler'),
        ('Programmfehler'),
        ('Vorgabe falsch'),
        ('Vorrichtung fehlerhaft'),
        ('Werkzeug falsch vermessen'),
        ('Werkzeugbruch');

 -- Vorgaben: (gesetzliche) globale Mindestpausen
 INSERT INTO minpause(mp_arbstu, mp_minpause)
 VALUES (6, 0.50), -- ab 6 h: 0,5 h Mindestpause
        (9, 0.75); -- ab 9 h: 0,75 h Mindestpause
 --
--

-- Vorgaben: Zertifikatstypen
    INSERT INTO pre_NormZertTyp(pnzt_type, pnzt_bez) VALUES
        ('N', 'Norm'),
        ('FN', 'Fertigungsnorm'),
        ('PN', 'Prüfnorm'),
        ('UN', 'Umweltnorm');
        --('NV', 'Normenverzeichnis'); --LOLL Normverwaltung im DB-Update


-- Auftragsstatus auftbs
    INSERT INTO auftgbs (as_bstat, as_bbez) VALUES ('M', 'Materialbuchung vorhanden');
    INSERT INTO auftgbs (as_bstat, as_bbez) VALUES ('W', 'Ware ausliefern | Warehouse Goods Issue');
    INSERT INTO auftgbs (as_bstat, as_bbez) VALUES ('U', 'Umsatzplanung');
    INSERT INTO auftgbs (as_bstat, as_bbez) VALUES ('FU', 'Umsatzplanung Folgemonat');
    INSERT INTO auftgbs (as_bstat, as_bbez) VALUES ('K', 'Konsignationslagerprozess');

    -- #9052 Freigabestatus auf Positionsebene in ABK
    INSERT INTO auftgbs (as_bstat, as_bbez) VALUES ('S', 'Position gesperrt'), ('F', 'Position freigegeben');


--Seriveauftragstypen
--INSERT INTO serviceauftgart (saa_id, saa_bez) VALUES (1, 'Garantie');
--INSERT INTO serviceauftgart (saa_id, saa_bez) VALUES (2, 'Wartung/Instandhaltung');
--INSERT INTO serviceauftgart (saa_id, saa_bez) VALUES (3, 'Reparatur');
--INSERT INTO serviceauftgart (saa_id, saa_bez) VALUES (4, 'Fehlersuche');

-- Einkaufsstatus
    INSERT INTO ldsdokbs (ls_bstat, ls_bez)
    VALUES ('E', 'Ware extern'),
           ('W', 'Ware eingetroffen | Warehouse Goods Receipt');

SELECT TSystem.Settings__Set('EINK_AUSW_CURRENTUSERISAP', 'T');

/* Lieferantenprüfungen im Assistenten Einkauf ~ Assistentregister wird aktiv; Steuerung über Dynamische Settings*/
--SELECT TSystem.Settings__Set('EINK_gehmverbrg_lief', 'F'); --Geheimhaltungsvereinbarung
--SELECT TSystem.Settings__Set('EINK_sauskft_lief', 'F'); --Selbstauskunft
--SELECT TSystem.Settings__Set('EINK_lue', 'F'); --Ursprungserklärung


-- DokumentNummer-Sequenzen mit Standardwert                                     27YY00000
    CREATE SEQUENCE ldsdok_ld_dokunr_seq            INCREMENT 1 MINVALUE 1 START 270000000;   --Bestelldokument
    CREATE SEQUENCE auswlog_aw_dokunr_seq           INCREMENT 1 MINVALUE 1 START 280000000;   --Auswärtsvergabe-Dokument
    CREATE SEQUENCE auftg_ag_dokunr__astat_a__seq   INCREMENT 1 MINVALUE 1 START 310000000;   --Angebotsdokument
    CREATE SEQUENCE auftg_ag_dokunr_seq             INCREMENT 1 MINVALUE 1 START 330000000;   --Auftragsdokument

    -- Update sowie Nummern von alten Systemen (24..26)
    -- ALTER SEQUENCE ldsdok_ld_dokunr_seq            RESTART WITH 272400000;   --Bestelldokument
    -- ALTER SEQUENCE auswlog_aw_dokunr_seq           RESTART WITH 282400000;   --Auswärtsvergabe-Dokument
    -- CREATE SEQUENCE auftg_ag_dokunr__astat_a__seq  INCREMENT 1 MINVALUE 1 START 312400000;   --Angebotsdokument
    -- ALTER SEQUENCE auftg_ag_dokunr__astat_a__seq   RESTART WITH 312400000;   --Angebotsdokument
    -- ALTER SEQUENCE auftg_ag_dokunr_seq             RESTART WITH 332400000;   --Auftragsdokument

-- Nummernkreise;
-- WiKi beachten, Codeanpassungen dort nachführen! https://redmine.prodat-sql.de/projects/prodat-v12-public/wiki/Nummernkreise
  -- Artikel
    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_num, nc_modulname, nc_checksql)
    VALUES ('art', 'autom. Artikelnummer', 1100000, 'TFormArtikel',
            'SELECT true FROM art WHERE ak_nr = :mynewchecknumber');


    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('artaw', 'Auswärtspaket', '''AW.'' || lpad(NC_NUM, 4, 0)', 0, 'TFormArtikel',
            'SELECT true FROM art WHERE ak_nr = :mynewchecknumber');

  -- Einkauf
    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_num, nc_preselect, nc_modulname,  nc_checksql)
    VALUES ('banf', 'Bestellanforderung', 0, 'to_char(current_date, ''IYIW'')', 'TFormBestAnforderung',
            'SELECT true FROM bestanftxt WHERE ba_nr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_num, nc_preselect, nc_modulname, nc_default)
    VALUES ('banf_monat', 'Bestellanforderung', 0, 'to_char(current_date, ''YYMM'')', 'TFormBestAnforderung', true);

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('anfrage', 'Anfrage an Lieferanten', '''ANFL'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormAnfrage',
            'SELECT true FROM anfrage WHERE anf_nr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('ldsdokr', 'Rahmenbestellung', '''RBE'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormEinkauf',
            'SELECT true FROM ldsdok WHERE ld_code = ''R'' AND ld_auftg = :mynewchecknumber');


    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('ldsdok', 'Bestellungen : FBE/BE', '''FBE'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormEinkauf',
            'SELECT true FROM ldsdok WHERE ifthen( getnumcircleactive(''ldsdoki''), ld_code = ''E'', ld_code IN (''E'', ''I'') )
                                                           AND ((ld_auftg = :mynewchecknumber) OR
                                                                (ld_auftg = (:mynewchecknumber || ''.QS'')) OR
                                                                (ld_auftg = ( REPLACE(:mynewchecknumber, ''FBE'', ''BE'') )) OR
                                                                (ld_auftg = ( REPLACE(:mynewchecknumber, ''FBE'', ''BE'') || ''.QS''))
                                                               )');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('ldsdoki', 'Fertigungsbestellungen : LA/PA', '''LA'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormEinkauf',
            'SELECT true FROM ldsdok WHERE ld_code = ''I'' AND ((ld_auftg = :mynewchecknumber) OR
                                                                (ld_auftg = (:mynewchecknumber || ''.QS'')) OR
                                                                (ld_auftg = ( REPLACE(:mynewchecknumber, ''LA'', ''PA'') )) OR
                                                                (ld_auftg = ( REPLACE(:mynewchecknumber, ''LA'', ''PA'') || ''.QS''))
                                                               )');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('eingrechnr', 'Eingangsrechnungen', '''ER'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormEingRech',
            'SELECT true FROM eingrechdokument WHERE beld_dokunr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_num, nc_modulname, nc_checksql)
    VALUES ('bestvorschlag', 'Bestellvorschlag', 2500000, 'TFormBestellVorschlag',
            'SELECT true FROM BestVorschlag WHERE bvs_nr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_num, nc_modulname, nc_checksql)
    VALUES ('zahlungslaufnr', 'Zahlungslauf-Nr.', 2600000, '',
            'SELECT true FROM zahlungslauf WHERE zl_nr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('ldsdokdm', 'Demontage / Upgrade / Umbau', '''DM'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormProdArtDemontage',
            'SELECT true FROM ldsdok WHERE ld_code = ''I'' AND ld_auftg = :mynewchecknumber AND TQS.ldsdok__demontage__is(ld_id)');

  -- Verkauf
    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('kanfrage', 'Anfrage von Kunden', '''ANFK'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormKundenAnfrage',
            'SELECT true FROM kundanfrage WHERE kanf_nr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('kanfrageser', 'Kundenanfragen', '''ANFS'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormServiceAnfrage',
            'SELECT true FROM kundanfrage WHERE kanf_nr = :mynewchecknumber');

    -- Einer für alles. Inaktiv, da nicht mehr so gemacht.
    INSERT INTO TSystem.numcircles (nc_ident, nc_active, nc_description, nc_num, nc_modulname, nc_checksql)
    VALUES ('auftg', false, 'Angebote an Kunden', 3150000, 'TFormAuftg',
            'SELECT true FROM auftg WHERE ((ag_nr = :mynewchecknumber) OR (ag_nr = (:mynewchecknumber || ''.QS'')))');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('aauftg', 'Angebote', '''AN'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, TSystem.Settings__GetInteger(''auftg__ag_nr__numlength'', 5), 0)', 100, 'TFormAuftg',
            'SELECT true FROM auftg WHERE ag_astat = ''A'' AND ((ag_nr = :mynewchecknumber) OR (ag_nr = (:mynewchecknumber || ''.QS'')))');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('eauftg', 'Kundenaufträge', '''AG'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormAuftg',
            'SELECT true FROM auftg WHERE ag_astat = ''E'' AND ((ag_nr = :mynewchecknumber) OR (ag_nr = (:mynewchecknumber || ''.QS'')))');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('rauftg', 'Rahmenaufträge', '''RA'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormAuftg',
            'SELECT true FROM auftg WHERE ag_astat = ''R'' AND (ag_nr = :mynewchecknumber)');

    -- Interessentenakquise
    INSERT INTO TSystem.numcircles (nc_ident, nc_active, nc_description, nc_num, nc_modulname, nc_checksql)
    VALUES ('iakquise', false, 'Interessentanakquise', 35000000, 'TFormKundenAnfrage',
            'SELECT true FROM kundanfrage WHERE kanf_nr = :mynewchecknumber');

    -- INSERT INTO TSystem.numcircles (nc_ident,nc_description,nc_preselect,nc_num,nc_modulname)
    -- VALUES ('service', 'Serviceauftragsnummer', 3400000, '');

  -- Lieferschein
    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('lifsch', 'Lieferschein an Kunden', '''LS'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormLFSBeleg',
            'SELECT true FROM lieferschein WHERE beld_dokunr = :mynewchecknumber');

  -- Faktura
    -- be_prof = ''R'' (auch G, R, P, T) entfernt, eindimensionaler PKey für alle be_prof.
    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_num_start, nc_modulname, nc_checksql)
    VALUES ('BE_BNR', 'Rechnung / Fallback', '''RG'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 0, 0, 'TFormFak',
            'SELECT true FROM belkopf WHERE be_bnr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_num_start, nc_modulname, nc_checksql)
    VALUES ('BE_BNR_G', 'Rechnungskorrektur', '''GS'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 0, 0, 'TFormFak',
            'SELECT true FROM belkopf WHERE be_bnr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_num_start, nc_modulname, nc_checksql)
    VALUES ('BE_BNR_P', 'Proforma', '''PR'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 0, 0, 'TFormFak',
            'SELECT true FROM belkopf WHERE be_bnr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_num_start, nc_modulname, nc_checksql)
    VALUES ('BE_BNR_A', 'Abschlagsrechnung', '''AR'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 0, 0, 'TFormFak',
            'SELECT true FROM belkopf WHERE be_bnr = :mynewchecknumber');

  -- Faktura Schweiz SwissQR nur Zahlen zulässig!
    -- be_prof = ''R'' (auch G, R, P, T) entfernt, eindimensionaler PKey für alle be_prof.
    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_num_start, nc_modulname, nc_checksql)
    VALUES ('BE_BNR__SWISSQR', 'Rechnung / Fallback',   'to_char(current_date, ''YY'') || ''14'' || lpad(NC_NUM, 4, 0)', 0, 0, 'TFormFak',
            'SELECT true FROM belkopf WHERE be_bnr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_num_start, nc_modulname, nc_checksql)
    VALUES ('BE_BNR_G__SWISSQR', 'Rechnungskorrektur',  'to_char(current_date, ''YY'') || ''13'' || lpad(NC_NUM, 4, 0)', 0, 0, 'TFormFak',
            'SELECT true FROM belkopf WHERE be_bnr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_num_start, nc_modulname, nc_checksql)
    VALUES ('BE_BNR_A__SWISSQR', 'Abschlagsrechnung',   'to_char(current_date, ''YY'') || ''12'' || lpad(NC_NUM, 4, 0)', 0, 0, 'TFormFak',
            'SELECT true FROM belkopf WHERE be_bnr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_num_start, nc_modulname, nc_checksql)
    VALUES ('BE_BNR_P__SWISSQR', 'Proforma',   '''P'' || to_char(current_date, ''YY'') || ''11'' || lpad(NC_NUM, 4, 0)', 0, 0, 'TFormFak',
            'SELECT true FROM belkopf WHERE be_bnr = :mynewchecknumber');


  -- Sonstiges
    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('anl', 'Projektnummern', '''PJ'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormProjVerwaltung',
            'SELECT true FROM anl WHERE an_nr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('anlres', 'Projekt.-Reservierung', '''PJ-R'' || to_char(current_date, ''YY'') || ''-'' || lpad(NC_NUM, 5, 0)', 100, 'TFormProjVerwaltung',
            'SELECT true FROM anl WHERE an_nr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_num, nc_modulname, nc_checksql)
    VALUES ('qab', 'QAB-Berichte', 4200000, 'TFormQAB',
            'SELECT true FROM qab WHERE q_nr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_num, nc_modulname, nc_checksql)
    VALUES ('qabser', 'Servicevorfälle', 5200000, 'TFormQAB',
            'SELECT true FROM qab WHERE q_nr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('preport', 'PR-Report', 'to_char(current_date, ''YYYY'') || lpad(NC_NUM, 4, 0)', 100, 'TFormProblemReport',
            'SELECT true FROM qab WHERE q_nr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_num, nc_checksql)
    VALUES ('web', 'Wareneingangs-Berichte', 4300000,
            'SELECT true FROM wareneingangskontrolle WHERE wek_nr = :mynewchecknumber');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_num, nc_modulname, nc_checksql)
    VALUES ('vertrag', 'Vertragsverwaltung', 4400000, 'TFormVertragsManagement',
            'SELECT true FROM vertrag WHERE vtr_nr = :mynewchecknumber');

    INSERT INTO settings (s_vari, s_inha)
    VALUES ('Vertrag.int_ldsdok.numkr', 'vertrag'),
           ('Vertrag.ext_auftg.numkr' , 'vertrag');

    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_num, nc_modulname, nc_checksql)
    VALUES ('werkzeug', 'Werkzeugverwaltung', 1000, 'TFormWerkzeug',
            'SELECT true FROM werkzeug WHERE wz_wznr = :mynewchecknumber');

    -- Änderungsverwaltung
    INSERT INTO TSystem.numcircles (nc_ident, nc_description, nc_preselect, nc_num, nc_modulname, nc_checksql)
    VALUES ('beleg_k__artchange', 'Änderungsmanagement', '''AM''||substr(CAST(EXTRACT(year FROM current_date) AS VARCHAR),3,2) || ''-''||lpad(NC_NUM, 5, 0)', 100, 'TFormAenderungsVerwaltung',
            'SELECT true FROM tartikel.beleg_k__artchange WHERE k_nummer=:mynewchecknumber LIMIT 1');



    UPDATE numcircles SET nc_num_restart = true
     WHERE nc_ident in('anfrage', 'kanfrageser', 'kanfrage',
                       'anl', 'anlres',
                       'BE_BNR', 'BE_BNR_A', 'BE_BNR_G', 'BE_BNR_P',
                       'beleg_k__artchange',
                       'eauftg', 'aauftg', 'rauftg',
                       'eingrechnr',
                       'ldsdokr', 'ldsdok', 'ldsdoki', 'ldsdokdm',
                       'lifsch');

--

-- Standardprojekt für Budget / Vertriebsplanung
INSERT INTO anl (an_nr, an_bez, an_lief, an_inst) VALUES ('BUDGET', 'Vertriebsplanung PRODAT, Systemprojekt', NULL, NULL);


-- Ländercodes-Länder-ISO
    INSERT INTO laender (l_iso, l_land) VALUES
                ('AD', 'Andorra'),
                ('AE', 'Vereinigte Arabische Emirate'),
                ('AF', 'Afghanistan'),
                ('AG', 'Antigua und Barbuda'),
                ('AI', 'Anguilla'),
                ('AL', 'Albanien'),
                ('AM', 'Armenien'),
                ('AO', 'Angola'),
                ('AQ', 'Antarktis'),
                ('AR', 'Argentinien'),
                ('AS', 'Amerikanisch-Samoa'),
                ('AT', 'Österreich'),
                ('AU', 'Australien'),
                ('AW', 'Aruba'),
                ('AX', 'Åland-Inseln'),
                ('AZ', 'Aserbaidschan'),
                ('BA', 'Bosnien und Herzegowina'),
                ('BB', 'Barbados'),
                ('BD', 'Bangladesch'),
                ('BE', 'Belgien'),
                ('BF', 'Burkina Faso'),
                ('BG', 'Bulgarien'),
                ('BH', 'Bahrain'),
                ('BI', 'Burundi'),
                ('BJ', 'Benin'),
                ('BL', 'Saint-Barthélemy'),
                ('BM', 'Bermuda'),
                ('BN', 'Brunei Darussalam'),
                ('BO', 'Bolivien'),
                ('BQ', 'Bonaire, Sint Eustatius und Saba'),
                ('BR', 'Brasilien'),
                ('BS', 'Bahamas'),
                ('BT', 'Bhutan'),
                ('BV', 'Bouvetinsel'),
                ('BW', 'Botswana'),
                ('BY', 'Belarus'),
                ('BZ', 'Belize'),
                ('CA', 'Kanada'),
                ('CC', 'Kokosinseln (Keelinginseln)'),
                ('CD', 'Demokratische Republik Kongo'),
                ('CF', 'Zentralafrikanische Republik'),
                ('CG', 'Kongo'),
                ('CH', 'Schweiz'),
                ('CI', 'Côte d’Ivoire'),
                ('CK', 'Cookinseln'),
                ('CL', 'Chile'),
                ('CM', 'Kamerun'),
                ('CN', 'China'),
                ('CO', 'Kolumbien'),
                ('CR', 'Costa Rica'),
                ('CU', 'Kuba'),
                ('CV', 'Cabo Verde'),
                ('CW', 'Curaçao'),
                ('CX', 'Weihnachtsinsel'),
                ('CY', 'Zypern'),
                ('CZ', 'Tschechien'),
                ('DE', 'Deutschland'),
                ('DJ', 'Dschibuti'),
                ('DK', 'Dänemark'),
                ('DM', 'Dominica'),
                ('DO', 'Dominikanische Republik'),
                ('DZ', 'Algerien'),
                ('EC', 'Ecuador'),
                ('EE', 'Estland'),
                ('EG', 'Ägypten'),
                ('EH', 'Westsahara'),
                ('ER', 'Eritrea'),
                ('ES', 'Spanien'),
                ('ET', 'Äthiopien'),
                ('FI', 'Finnland'),
                ('FJ', 'Fidschi'),
                ('FK', 'Falklandinseln'),
                ('FM', 'Mikronesien'),
                ('FO', 'Färöer-Inseln'),
                ('FR', 'Frankreich'),
                ('GA', 'Gabun'),
                ('GB', 'Großbritannien'),
                ('GD', 'Grenada'),
                ('GE', 'Georgien'),
                ('GF', 'Französisch-Guayana'),
                ('GG', 'Guernsey'),
                ('GH', 'Ghana'),
                ('GI', 'Gibraltar'),
                ('GL', 'Grönland'),
                ('GM', 'Gambia'),
                ('GN', 'Guinea'),
                ('GP', 'Guadeloupe'),
                ('GQ', 'Äquatorialguinea'),
                ('GR', 'Griechenland'),
                ('GS', 'Südgeorgien und die Südlichen Sandwichinseln'),
                ('GT', 'Guatemala'),
                ('GU', 'Guam'),
                ('GW', 'Guinea-Bissau'),
                ('GY', 'Guyana'),
                ('HK', 'Hongkong'),
                ('HM', 'Heard und McDonaldinseln'),
                ('HN', 'Honduras'),
                ('HR', 'Kroatien'),
                ('HT', 'Haiti'),
                ('HU', 'Ungarn'),
                ('ID', 'Indonesien'),
                ('IE', 'Irland'),
                ('IL', 'Israel'),
                ('IM', 'Isle of Man'),
                ('IN', 'Indien'),
                ('IO', 'Britisches Territorium im Indischen Ozean'),
                ('IQ', 'Irak'),
                ('IR', 'Iran'),
                ('IS', 'Island'),
                ('IT', 'Italien'),
                ('JE', 'Jersey'),
                ('JM', 'Jamaika'),
                ('JO', 'Jordanien'),
                ('JP', 'Japan'),
                ('KE', 'Kenia'),
                ('KG', 'Kirgisistan'),
                ('KH', 'Kambodscha'),
                ('KI', 'Kiribati'),
                ('KM', 'Komoren'),
                ('KN', 'St. Kitts und Nevis'),
                ('KP', 'Nordkorea'),
                ('KR', 'Südkorea'),
                ('KW', 'Kuwait'),
                ('KY', 'Kaimaninseln'),
                ('KZ', 'Kasachstan'),
                ('LA', 'Laos'),
                ('LB', 'Libanon'),
                ('LC', 'St. Lucia'),
                ('LI', 'Liechtenstein'),
                ('LK', 'Sri Lanka'),
                ('LR', 'Liberia'),
                ('LS', 'Lesotho'),
                ('LT', 'Litauen'),
                ('LU', 'Luxemburg'),
                ('LV', 'Lettland'),
                ('LY', 'Libyen'),
                ('MA', 'Marokko'),
                ('MC', 'Monaco'),
                ('MD', 'Republik Moldau'),
                ('ME', 'Montenegro'),
                ('MF', 'Saint-Martin'),
                ('MG', 'Madagaskar'),
                ('MH', 'Marshallinseln'),
                ('MK', 'Nordmazedonien'),
                ('ML', 'Mali'),
                ('MM', 'Myanmar'),
                ('MN', 'Mongolei'),
                ('MO', 'Macao'),
                ('MP', 'Nördliche Marianen'),
                ('MQ', 'Martinique'),
                ('MR', 'Mauretanien'),
                ('MS', 'Montserrat'),
                ('MT', 'Malta'),
                ('MU', 'Mauritius'),
                ('MV', 'Malediven'),
                ('MW', 'Malawi'),
                ('MX', 'Mexiko'),
                ('MY', 'Malaysia'),
                ('MZ', 'Mosambik'),
                ('NA', 'Namibia'),
                ('NC', 'Neukaledonien'),
                ('NE', 'Niger'),
                ('NF', 'Norfolkinsel'),
                ('NG', 'Nigeria'),
                ('NI', 'Nicaragua'),
                ('NL', 'Niederlande'),
                ('NO', 'Norwegen'),
                ('NP', 'Nepal'),
                ('NR', 'Nauru'),
                ('NU', 'Niue'),
                ('NZ', 'Neuseeland'),
                ('OM', 'Oman'),
                ('PA', 'Panama'),
                ('PE', 'Peru'),
                ('PF', 'Französisch-Polynesien'),
                ('PG', 'Papua-Neuguinea'),
                ('PH', 'Philippinen'),
                ('PK', 'Pakistan'),
                ('PL', 'Polen'),
                ('PM', 'Saint-Pierre und Miquelon'),
                ('PN', 'Pitcairninseln'),
                ('PR', 'Puerto Rico'),
                ('PS', 'Staat Palästina'),
                ('PT', 'Portugal'),
                ('PW', 'Palau'),
                ('PY', 'Paraguay'),
                ('QA', 'Katar'),
                ('RE', 'Réunion'),
                ('RO', 'Rumänien'),
                ('RS', 'Serbien'),
                ('RU', 'Russische Föderation'),
                ('RW', 'Ruanda'),
                ('SA', 'Saudi-Arabien'),
                ('SB', 'Salomonen'),
                ('SC', 'Seychellen'),
                ('SD', 'Sudan'),
                ('SE', 'Schweden'),
                ('SG', 'Singapur'),
                ('SH', 'St. Helena, Ascension und Tristan da Cunha'),
                ('SI', 'Slowenien'),
                ('SJ', 'Spitzbergen und Jan Mayen'),
                ('SK', 'Slowakei'),
                ('SL', 'Sierra Leone'),
                ('SM', 'San Marino'),
                ('SN', 'Senegal'),
                ('SO', 'Somalia'),
                ('SR', 'Suriname'),
                ('SS', 'Südsudan'),
                ('ST', 'São Tomé und Príncipe'),
                ('SV', 'El Salvador'),
                ('SX', 'Sint Maarten'),
                ('SY', 'Syrien'),
                ('SZ', 'Eswatini'),
                ('TC', 'Turks- und Caicosinseln'),
                ('TD', 'Tschad'),
                ('TF', 'Französische Süd- und Antarktisgebiete'),
                ('TG', 'Togo'),
                ('TH', 'Thailand'),
                ('TJ', 'Tadschikistan'),
                ('TK', 'Tokelau'),
                ('TL', 'Timor-Leste'),
                ('TM', 'Turkmenistan'),
                ('TN', 'Tunesien'),
                ('TO', 'Tonga'),
                ('TR', 'Türkei'),
                ('TT', 'Trinidad und Tobago'),
                ('TV', 'Tuvalu'),
                ('TW', 'Taiwan'),
                ('TZ', 'Tansania'),
                ('UA', 'Ukraine'),
                ('UG', 'Uganda'),
                ('UM', 'United States Minor Outlying Islands'),
                ('US', 'Vereinigte Staaten von Amerika'),
                ('UY', 'Uruguay'),
                ('UZ', 'Usbekistan'),
                ('VA', 'Heiliger Stuhl (Vatikanstadt)'),
                ('VC', 'St. Vincent und die Grenadinen'),
                ('VE', 'Venezuela'),
                ('VG', 'Britische Jungferninseln'),
                ('VI', 'Amerikanische Jungferninseln'),
                ('VN', 'Vietnam'),
                ('VU', 'Vanuatu'),
                ('WF', 'Wallis und Futuna'),
                ('WS', 'Samoa'),
                ('YE', 'Jemen'),
                ('YT', 'Mayotte'),
                ('ZA', 'Südafrika'),
                ('ZM', 'Sambia'),
                ('ZW', 'Simbabwe'),
                ('XK', 'Kosovo');
--

-- Länder-IBAN-Formate
    INSERT INTO laender_iban_formats (iban_iso, iban_expected_length, iban_regex)
                VALUES
                -- Albanien
                ('AL', 28, E'^AL\\d{2}\\d{8}\\d{16}$'),
                -- Andorra
                ('AD', 24, E'^AD\\d{2}\\d{4}\\d{4}[A-Z0-9]{12}$'),
                -- Vereinigte Arabische Emirate
                ('AE', 23, E'^AE\\d{2}\\d{3}\\d{16}$'),
                -- Österreich
                ('AT', 20, E'^AT\\d{2}\\d{5}\\d{11}$'),
                -- Aserbaidschan
                ('AZ', 28, E'^AZ\\d{2}[A-Z]{4}[A-Z0-9]{20}$'),
                -- Bosnien und Herzegowina
                ('BA', 20, E'^BA\\d{2}\\d{3}\\d{3}\\d{8}\\d{2}$'),
                -- Belgien
                ('BE', 16, E'^BE\\d{2}\\d{3}\\d{7}\\d{2}$'),
                -- Bulgarien
                ('BG', 22, E'^BG\\d{2}[A-Z]{4}\\d{4}\\d{2}[A-Z0-9]{8}$'),
                -- Bahrain
                ('BH', 22, E'^BH\\d{2}[A-Z]{4}[A-Z0-9]{14}$'),
                -- Brasilien
                ('BR', 29, E'^BR\\d{2}\\d{8}\\d{5}\\d{10}[A-Z]{1}[A-Z0-9]{1}$'),
                -- Belarus
                ('BY', 28, E'^BY\\d{2}[A-Z0-9]{4}\\d{4}[A-Z0-9]{16}$'),
                -- Schweiz
                ('CH', 21, E'^CH\\d{2}\\d{5}[A-Z0-9]{12}$'),
                -- Costa Rica
                ('CR', 22, E'^CR\\d{2}\\d{4}\\d{14}$'),
                -- Zypern
                ('CY', 28, E'^CY\\d{2}\\d{3}\\d{5}[A-Z0-9]{16}$'),
                -- Tschechische Republik
                ('CZ', 24, E'^CZ\\d{2}\\d{20}$'),
                -- Deutschland
                ('DE', 22, E'^DE\\d{2}\\d{18}$'),
                -- Dänemark
                ('DK', 18, E'^DK\\d{2}\\d{14}$'),
                -- Dominikanische Republik
                ('DO', 28, E'^DO\\d{2}[A-Z0-9]{4}\\d{20}$'),
                -- Estland
                ('EE', 20, E'^EE\\d{2}\\d{2}\\d{2}\\d{11}\\d{1}$'),
                -- Spanien
                ('ES', 24, E'^ES\\d{2}\\d{4}\\d{4}\\d{1}\\d{1}\\d{10}$'),
                -- Finnland
                ('FI', 18, E'^FI\\d{2}\\d{6}\\d{7}\\d{1}$'),
                -- Färöer Inseln
                ('FO', 18, E'^FO\\d{2}\\d{4}\\d{9}\\d{1}$'),
                -- Frankreich
                ('FR', 27, E'^FR\\d{2}\\d{5}\\d{5}[A-Z0-9]{11}\\d{2}$'),
                -- Vereinigtes Königreich
                ('GB', 22, E'^GB\\d{2}[A-Z]{4}\\d{14}$'),
                -- Georgien
                ('GE', 22, E'^GE\\d{2}[A-Z]{2}\\d{16}$'),
                -- Gibraltar
                ('GI', 23, E'^GI\\d{2}[A-Z]{4}[A-Z0-9]{15}$'),
                -- Grönland
                ('GL', 18, E'^GL\\d{2}\\d{4}\\d{9}\\d{1}$'),
                -- Griechenland
                ('GR', 27, E'^GR\\d{2}\\d{3}\\d{4}[A-Z0-9]{16}$'),
                -- Guatemala
                ('GT', 28, E'^GT\\d{2}[A-Z0-9]{4}[A-Z0-9]{20}$'),
                -- Kroatien
                ('HR', 21, E'^HR\\d{2}\\d{7}\\d{10}$'),
                -- Ungarn
                ('HU', 28, E'^HU\\d{2}\\d{3}\\d{4}\\d{1}\\d{15}\\d{1}$'),
                -- Irland
                ('IE', 22, E'^IE\\d{2}[A-Z]{4}\\d{6}\\d{8}$'),
                -- Israel
                ('IL', 23, E'^IL\\d{2}\\d{3}\\d{3}\\d{13}$'),
                -- Iran
                ('IR', 26, E'^IR\\d{2}\\d{22}$'),
                -- Island
                ('IS', 26, E'^IS\\d{2}\\d{4}\\d{2}\\d{6}\\d{10}$'),
                -- Italien
                ('IT', 27, E'^IT\\d{2}[A-Z]{1}\\d{5}\\d{5}[A-Z0-9]{12}$'),
                -- Jordanien
                ('JO', 30, E'^JO\\d{2}[A-Z]{4}\\d{4}[A-Z0-9]{18}$'),
                -- Kuwait
                ('KW', 30, E'^KW\\d{2}[A-Z]{4}[A-Z0-9]{22}$'),
                -- Kasachstan
                ('KZ', 20, E'^KZ\\d{2}\\d{3}[A-Z0-9]{13}$'),
                -- Libanon
                ('LB', 28, E'^LB\\d{2}\\d{4}[A-Z0-9]{20}$'),
                -- St. Lucia
                ('LC', 32, E'^LC\\d{2}[A-Z]{4}[A-Z0-9]{24}$'),
                -- Liechtenstein
                ('LI', 21, E'^LI\\d{2}\\d{5}[A-Z0-9]{12}$'),
                -- Litauen
                ('LT', 20, E'^LT\\d{2}\\d{5}\\d{11}$'),
                -- Luxemburg
                ('LU', 20, E'^LU\\d{2}\\d{3}[A-Z0-9]{13}$'),
                -- Lettland
                ('LV', 21, E'^LV\\d{2}[A-Z]{4}[A-Z0-9]{13}$'),
                -- Monaco
                ('MC', 27, E'^MC\\d{2}\\d{5}\\d{5}[A-Z0-9]{11}\\d{2}$'),
                -- Moldawien
                ('MD', 24, E'^MD\\d{2}[A-Z0-9]{2}[A-Z0-9]{18}$'),
                -- Montenegro
                ('ME', 22, E'^ME\\d{2}\\d{3}\\d{13}\\d{2}$'),
                -- Nordmazedonien
                ('MK', 19, E'^MK\\d{2}\\d{3}[A-Z0-9]{10}\\d{2}$'),
                -- Mauretanien
                ('MR', 27, E'^MR\\d{2}\\d{5}\\d{5}\\d{11}\\d{2}$'),
                -- Malta
                ('MT', 31, E'^MT\\d{2}[A-Z]{4}\\d{5}[A-Z0-9]{18}$'),
                -- Mauritius
                ('MU', 30, E'^MU\\d{2}[A-Z]{4}\\d{19}[A-Z]{3}$'),
                -- Niederlande
                ('NL', 18, E'^NL\\d{2}[A-Z]{4}\\d{10}$'),
                -- Norwegen
                ('NO', 15, E'^NO\\d{2}\\d{4}\\d{6}\\d{1}$'),
                -- Pakistan
                ('PK', 24, E'^PK\\d{2}[A-Z]{4}[A-Z0-9]{16}$'),
                -- Polen
                ('PL', 28, E'^PL\\d{2}\\d{8}\\d{16}$'),
                -- Palästinensische Gebiete
                ('PS', 29, E'^PS\\d{2}[A-Z]{4}[A-Z0-9]{21}$'),
                -- Portugal
                ('PT', 25, E'^PT\\d{2}\\d{4}\\d{4}\\d{11}\\d{2}$'),
                -- Katar
                ('QA', 29, E'^QA\\d{2}[A-Z]{4}[A-Z0-9]{21}$'),
                -- Rumänien
                ('RO', 24, E'^RO\\d{2}[A-Z]{4}[A-Z0-9]{16}$'),
                -- Serbien
                ('RS', 22, E'^RS\\d{2}\\d{3}\\d{13}\\d{2}$'),
                -- Saudi-Arabien
                ('SA', 24, E'^SA\\d{2}\\d{2}[A-Z0-9]{18}$'),
                -- Seychellen
                ('SC', 31, E'^SC\\d{2}[A-Z]{4}\\d{20}[A-Z]{3}$'),
                -- Schweden
                ('SE', 24, E'^SE\\d{2}\\d{3}\\d{16}\\d{1}$'),
                -- Slowenien
                ('SI', 19, E'^SI\\d{2}\\d{5}\\d{8}\\d{2}$'),
                -- Slowakei
                ('SK', 24, E'^SK\\d{2}\\d{4}\\d{6}\\d{10}$'),
                -- San Marino
                ('SM', 27, E'^SM\\d{2}[A-Z]{1}\\d{5}\\d{5}[A-Z0-9]{12}$'),
                -- São Tomé und Príncipe
                ('ST', 25, E'^ST\\d{2}\\d{8}\\d{11}\\d{2}$'),
                -- Osttimor
                ('TL', 23, E'^TL\\d{2}\\d{3}\\d{14}\\d{2}$'),
                -- Tunesien
                ('TN', 24, E'^TN\\d{2}\\d{2}\\d{3}\\d{13}\\d{2}$'),
                -- Türkei
                ('TR', 26, E'^TR\\d{2}\\d{5}[A-Z0-9]{17}$'),
                -- Ukraine
                ('UA', 29, E'^UA\\d{2}\\d{6}[A-Z0-9]{19}$'),
                -- Britische Jungferninseln
                ('VG', 24, E'^VG\\d{2}[A-Z]{4}\\d{16}$'),
                -- Kosovo
                ('XK', 20, E'^XK\\d{2}\\d{4}\\d{10}\\d{2}$'),
                -- Ägypten
                ('EG', 27, E'^EG\\d{2}\\d{4}\\d{4}\\d{17}$'),
                -- Guernsey
                ('GG', 22, E'^GG\\d{2}[A-Z]{4}\\d{14}$'),
                -- Isle of Man
                ('IM', 22, E'^IM\\d{2}[A-Z]{4}\\d{14}$'),
                -- Jersey
                ('JE', 22, E'^JE\\d{2}[A-Z]{4}\\d{14}$');
--

    -- Sonst kann man SystemEinstellungen nicht speichern, weil '' kein Laenderkuerzel ist.
    INSERT INTO settings(s_vari, s_owner, s_inha) VALUES ('ad_landisovorgabe','','DE');


-- Auswärtskategorien
    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (100, 'Montage allgemein');
    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (102, 'Vormontage');
    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (103, 'Endmontage');

    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (200, 'Bohren allgemein');
    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (202, 'Tiefbohren');
    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (203, 'Gewindebohren');

    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (300, 'Drehen allgemein');
    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (302, 'Drehen lang');
    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (303, 'Drehen plan');

    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (400, 'Fräsen allgemein');
    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (402, 'Fräsen Gewinde');

    INSERT INTO op2kat (o2k_id, o2k_bez) VALUES (010, 'Abrüsten');

--Verkauf
INSERT INTO zpstat(zp_status, zp_bez) VALUES ('R', 'Freigabe Rechnung');


-- Vorgaben Qualifikationsmanagement
    --**
    INSERT INTO mitarbrollen (mar_id, mar_descr) VALUES (0,'Alle Mitarbeiter');


    --**Ausbildung und Abschlüsse QL-AA
    INSERT INTO skillbew (sbw_note, sbw_descr, sbw_ak_ac) VALUES (1,'Sehr gut','QL-AA');
    INSERT INTO skillbew (sbw_note, sbw_descr, sbw_ak_ac) VALUES (2,'Gut','QL-AA');
    INSERT INTO skillbew (sbw_note, sbw_descr, sbw_ak_ac) VALUES (3,'Befriedigend','QL-AA');
    INSERT INTO skillbew (sbw_note, sbw_descr, sbw_ak_ac) VALUES (4,'Genügend','QL-AA');
    INSERT INTO skillbew (sbw_note, sbw_descr, sbw_ak_ac) VALUES (5,'Ungenügend','QL-AA');

    --**Ausbildung und Abschlüsse QL-FS
    --LG - Misthaufen: Wenn wir sowas schon vorgeben, legen wir dann bitte die ACs gleich mit an?!?
    INSERT INTO skillbew (sbw_note, sbw_descr, sbw_ak_ac) VALUES (1,'Muttersprache','QL-FS');
    INSERT INTO skillbew (sbw_note, sbw_descr, sbw_ak_ac) VALUES (2,'Sehr Gut','QL-FS');
    INSERT INTO skillbew (sbw_note, sbw_descr, sbw_ak_ac) VALUES (3,'Gut','QL-FS');
--

-- Vorgaben Personalmanagement
    -- Art der Anstellung
    INSERT INTO anstellart (arta_id, arta_descr) VALUES (1,'Festanstellung');
    INSERT INTO anstellart (arta_id, arta_descr) VALUES (2,'Zeitarbeiter');
    INSERT INTO anstellart (arta_id, arta_descr) VALUES (3,'Auszubildender');
    INSERT INTO anstellart (arta_id, arta_descr) VALUES (4,'Diplomand');
    SELECT setval('anstellart_arta_id_seq', 20, false);

    -- Personalgruppe
    INSERT INTO persgruppe (persg_id, persg_descr) VALUES (1,'Personalgruppe A');
    INSERT INTO persgruppe (persg_id, persg_descr) VALUES (2,'Personalgruppe B');
    INSERT INTO persgruppe (persg_id, persg_descr) VALUES (3,'Personalgruppe C');
    INSERT INTO persgruppe (persg_id, persg_descr) VALUES (4,'Kernteam');
    INSERT INTO persgruppe (persg_id, persg_descr) VALUES (5,'Temporärteam');

    -- Art des Arbeitsentgelts
    INSERT INTO recnogroup(reg_tablename, reg_pos, reg_pname,          reg_bez,                   reg_bez_textno, reg_gruppe, reg_gruppe_textno, reg_paramtype, reg_visible, reg_exclusive)
    SELECT                 'personal',    10,      'personal.entgelt', 'Art des Arbeitsentgelts', 16760,          'Vorgaben', 26456,             'ptENUM',      true,        false;
    INSERT INTO recnoenums(rege_reg_pname,     rege_pos, rege_code, rege_bez)
    VALUES                ('personal.entgelt', 1,        'GEHA',    'Gehalt'),
                          ('personal.entgelt', 2,        'LOHN',    'Lohn'),
                          ('personal.entgelt', 3,        'AZUBI',   'Ausbildungsvergütung'),
                          ('personal.entgelt', 4,        'LOHNF',   'Fixer Lohn');


-- Vorgabeliste für PrintSettings Mehrauswahl
    INSERT INTO recnogroup(reg_tablename, reg_pos, reg_pname,               reg_bez,         reg_bez_textno, reg_gruppe, reg_gruppe_textno, reg_paramtype, reg_vorgabenliste, reg_visible, reg_exclusive)
    SELECT                 'settingsdyn', 10,      'sd.PrintSettings.enum', 'PrintSettings', 26109,          'Vorgaben', 26456,             'ptENUM',      true,             true,        false;
    INSERT INTO recnoenums(rege_reg_pname,          rege_pos, rege_code,        rege_bez)
    VALUES                ('sd.PrintSettings.enum', 10,       'psPageBreak',    'Neue Seite'),
                          ('sd.PrintSettings.enum', 20,       'psSubTotal',     'Zwischensumme'),
                          ('sd.PrintSettings.enum', 30,       'psPosTxt',       'Positionszusatztext nicht anzeigen'),
                          ('sd.PrintSettings.enum', 40,       'psPriceMainPos', 'Nur Preis der Hauptposition ausweisen'),
                          ('sd.PrintSettings.enum', 50,       'psSubPosHide',   'Unterposition nicht ausweisen'); --Unterposition nicht ausweisen

--Zahlungsarten
    INSERT INTO zahlart(za_id, za_bez) VALUES (1, 'Bar');
    INSERT INTO zahlart(za_id, za_bez) VALUES (2, 'Überweisung');
    INSERT INTO zahlart(za_id, za_bez) VALUES (3, 'Lastschrift');

--Funktionen (Projektverwaltung)
    INSERT INTO anl_pfunktion (pfu_krz, pfu_bez) VALUES ('GF', 'Geschäftsführung');
    INSERT INTO anl_pfunktion (pfu_krz, pfu_bez) VALUES ('PL', 'Projektleiter');
    INSERT INTO anl_pfunktion (pfu_krz, pfu_bez) VALUES ('BL', 'Bauleiter');

--Versandarten
    INSERT INTO versart(v_art) VALUES ('frei Haus');
    INSERT INTO versart(v_art) VALUES ('Spedition');
    INSERT INTO versart(v_art) VALUES ('Abholung');
    INSERT INTO versart(v_art, v_stat) VALUES ('Direktlieferung', 'D');  --#20807



--QS
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (1, 'Arbeitsplan falsch', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (2, 'Programm falsch', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (3, 'Zeichnung falsch', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (4, 'Auftragsänderung', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (5, 'Stornierung', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (6, 'Terminverfolgung mangelhaft', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (7, 'Beistellung fehlt', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (8, 'Meßmittel fehlt', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (9, 'Material fehlt', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (10, 'Materialfehler', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (11, 'Beschädigung', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (12, 'Werkzeugfehler', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (13, 'Bedienungsfehler', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (14, 'Meßfehler', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (15, 'Maschinengenauigkeit', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (16, 'WKZ Voreinstellung', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (17, 'Paßmaß nicht i.O.', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (18, 'Entgratung', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (19, 'Einrichtung mangelhaft', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (20, 'Vorrichtung mangelhaft', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (21, 'Maßfehler', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (22, 'Maschinenausfall', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (23, 'Oberflächen', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (24, 'Andere', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (25, 'Sicherheit', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (26, 'Gesundheit', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (27, 'Umwelt', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (28, 'Sauberkeit', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (29, 'Vorbereitung mangelhaft', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (30, 'Konturfehler', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (31, 'Abdeckfehler', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (32, 'Andere', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (33, 'Aussehen', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (34, 'Cadmieren', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (35, 'Chromatieren', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (36, 'Drallfrei', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (37, 'Eloxieren', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (38, 'Glasperlstrahlen', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (40, 'Harteloxieren', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (42, 'Korrosion', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (43, 'Kratzer', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (44, 'Kupfer', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (45, 'Lackieren', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (47, 'Nicht ausgeführt', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (48, 'Passivieren', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (49, 'Phosfatieren', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (50, 'Phosphatieren', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (51, 'Rauheit', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (52, 'Schw. Zink', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (53, 'TIN Most', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (54, 'Verchromen', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (55, 'Vernickeln', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (56, 'Versilbern / Vergolden', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (57, 'Verzinken', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (58, 'Anschl. Warmbehandlung', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (59, 'Arbeitsplan falsch', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (60, 'Lieferant', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (61, 'Maschinengenauigkeit', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (62, 'Messmittel', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (63, 'Mitarbeiterfehler', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (64, 'Programmfehler', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (65, 'Prüfanweisung fehlt', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (66, 'Spannfehler', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (67, 'Vorrichtungsfehler', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (68, 'Werkzeugfehler', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (69, 'Werkzeugplan falsch', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (70, 'Zeichnungsfehler', 'Paßmaßfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (73, 'Funktionsfehler', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (72, 'Brünieren', 'Oberflächenfehler');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (74, 'Kennzeichnung', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (75, 'Gewinde', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (77, 'Montagefehler', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (79, 'Löten', '');
    INSERT INTO qabfehler (qfeh_id, qfeh_bez, qfeh_grup) VALUES (80, 'Schweißen', '');

    INSERT INTO qabfehler (qfeh_id, qfeh_grup, qfeh_bez, qfeh_isService) VALUES (132, 'Kein Fehler', 'Kein Fehler', TRUE); -- ID hat Verwendung in Funktion doABK

    INSERT INTO qabsofort (qsof_id, qsof_bez) VALUES (1, 'Lagerbestand prüfen');
    INSERT INTO qabsofort (qsof_id, qsof_bez) VALUES (2, 'Vorfertigung prüfen');
    INSERT INTO qabsofort (qsof_id, qsof_bez) VALUES (3, 'Laufende Aufträge prüfen');
    INSERT INTO qabsofort (qsof_id, qsof_bez) VALUES (5, 'Teile vom Kunden abholen');
    INSERT INTO qabsofort (qsof_id, qsof_bez) VALUES (6, 'Kundenbesuch');
    INSERT INTO qabsofort (qsof_id, qsof_bez) VALUES (7, 'Lieferant Informieren');
    INSERT INTO qabsofort (qsof_id, qsof_bez) VALUES (8, 'Auftrag stoppen');
    INSERT INTO qabsofort (qsof_id, qsof_bez) VALUES (10, 'Programm Sperren');

    INSERT INTO qabklasse (qkla_id, qkla_bez) VALUES (1, 'Fehlerbeseitigung');
    INSERT INTO qabklasse (qkla_id, qkla_bez) VALUES (2, 'Korrekturmaßnahme');
    INSERT INTO qabklasse (qkla_id, qkla_bez) VALUES (3, 'Vorbeugemaßnahme');
    INSERT INTO qabklasse (qkla_id, qkla_bez) VALUES (4, 'Dient der internen Dokumentation');

    INSERT INTO qabentscheid (qent_id, qent_bez) VALUES (1, 'Offen');
    INSERT INTO qabentscheid (qent_id, qent_bez) VALUES (2, 'Tolerierung');
    INSERT INTO qabentscheid (qent_id, qent_bez) VALUES (3, 'Nacharbeit');
    INSERT INTO qabentscheid (qent_id, qent_bez) VALUES (4, 'verschrotten');
    INSERT INTO qabentscheid (qent_id, qent_bez) VALUES (5, 'Rücksendung');
    INSERT INTO qabentscheid (qent_id, qent_bez) VALUES (6, 'Kundenkontakt');
    INSERT INTO qabentscheid (qent_id, qent_bez) VALUES (7, 'Lieferantenkontakt');
    INSERT INTO qabentscheid (qent_id, qent_bez) VALUES (8, 'Schulung');
    INSERT INTO qabentscheid (qent_id, qent_bez) VALUES (9, 'Stellungnahme');

    INSERT INTO qabentscheid (qent_id, qent_bez, qent_isService) VALUES (20, 'Rechnung', TRUE); -- ID hat Verwendung in Funktion doABK
    INSERT INTO qabentscheid (qent_id, qent_bez, qent_isService) VALUES (21, 'Gewährleistung', TRUE);
    INSERT INTO qabentscheid (qent_id, qent_bez, qent_isService) VALUES (22, 'Kulanz', TRUE);
    INSERT INTO qabentscheid (qent_id, qent_bez, qent_isService) VALUES (23, 'Produktgarantie', TRUE);

    INSERT INTO qababteilung (qabt_id, qabt_bez) VALUES (1, 'Vertrieb');
    INSERT INTO qababteilung (qabt_id, qabt_bez) VALUES (2, 'Einkauf');
    INSERT INTO qababteilung (qabt_id, qabt_bez) VALUES (3, 'AVOR');
    INSERT INTO qababteilung (qabt_id, qabt_bez) VALUES (4, 'Montage');
    INSERT INTO qababteilung (qabt_id, qabt_bez) VALUES (5, 'Kunde');
    INSERT INTO qababteilung (qabt_id, qabt_bez) VALUES (6, 'Lieferant');
    INSERT INTO qababteilung (qabt_id, qabt_bez) VALUES (7, 'Materialwirtschaft');
    INSERT INTO qababteilung (qabt_id, qabt_bez) VALUES (8, 'Unbekannt');

    INSERT INTO qababteilung (qabt_id, qabt_bez, qabt_isService) VALUES (99, 'Wartungszyklus', TRUE); -- ID hat Verwendung in Funktion doABK
--

-- Zahlungslauf
    INSERT INTO zahlungslauftyp (zlt_id, zlt_bez) VALUES (0, 'Inlandsrechnungen (EUR, DTA)');  -- Veraltet ab 08/2014
    INSERT INTO zahlungslauftyp (zlt_id, zlt_bez) VALUES (1, 'Inlandsrechnungen (EUR, Manuell)');
    INSERT INTO zahlungslauftyp (zlt_id, zlt_bez) VALUES (2, 'Auslandsrechnungen (EUR, Manuell)');
    INSERT INTO zahlungslauftyp (zlt_id, zlt_bez) VALUES (3, 'Fremdwährungsrechnung (Manuell)');
    INSERT INTO zahlungslauftyp (zlt_id, zlt_bez) VALUES (4, 'Alle offenen Rechnungen (Manuell)');
    INSERT INTO zahlungslauftyp (zlt_id, zlt_bez, zlt_default) VALUES (5, 'Inlandsrechnungen (DE, SEPA)', TRUE);

-- Belegtitel (Belegmodul)
    INSERT INTO beltitel (bt_id, bt_bez, bt_isrech, bt_isang, bt_isbes, bt_islief, bt_isvtr) VALUES (1,'Rahmenbestellung',FALSE, FALSE, TRUE, FALSE, FALSE);
    INSERT INTO beltitel (bt_id, bt_bez, bt_isrech, bt_isang, bt_isbes, bt_islief, bt_isvtr) VALUES (2,'Abschlagsrechnung',TRUE, FALSE, FALSE, FALSE, FALSE);
    INSERT INTO beltitel (bt_id, bt_bez, bt_isrech, bt_isang, bt_isbes, bt_islief, bt_isvtr) VALUES (3,'Schlussrechnung',TRUE, FALSE, FALSE, FALSE, FALSE);
    INSERT INTO beltitel (bt_id, bt_bez, bt_isrech, bt_isang, bt_isbes, bt_islief, bt_isvtr) VALUES (4,'Lieferschein',FALSE, FALSE, FALSE, TRUE, FALSE);
    INSERT INTO beltitel (bt_id, bt_bez, bt_isrech, bt_isang, bt_isbes, bt_islief, bt_isvtr) VALUES (5,'Angebot',FALSE, TRUE, FALSE, FALSE, FALSE);
    INSERT INTO beltitel (bt_id, bt_bez, bt_isrech, bt_isang, bt_isbes, bt_islief, bt_isvtr) VALUES (6,'Wartungsvertrag',FALSE, FALSE, FALSE, FALSE, TRUE);
    INSERT INTO beltitel (bt_id, bt_bez, bt_isrech, bt_isang, bt_isbes, bt_islief, bt_isvtr) VALUES (7,'Leasingvertrag',FALSE, FALSE, FALSE, FALSE, TRUE);
    INSERT INTO beltitel (bt_id, bt_bez, bt_isrech, bt_isang, bt_isbes, bt_islief, bt_isvtr) VALUES (8,'Mietvertrag',FALSE, FALSE, FALSE, FALSE, TRUE);
    INSERT INTO beltitel (bt_id, bt_bez, bt_isrech, bt_isang, bt_isbes, bt_islief, bt_isvtr) VALUES (9,'Versicherungsvertrag',FALSE, FALSE, FALSE, FALSE, TRUE);



-- Interessentenanfrage / Kundenanfrage
     --Status
    INSERT INTO kundanfstat(kanfs_status, kanfs_bez, kanfs_isService) VALUES ('A', 'Ausschreibung', False); --fix
    INSERT INTO kundanfstat(kanfs_status, kanfs_bez, kanfs_isService) VALUES ('B', 'Beauftragt', TRUE);
    INSERT INTO kundanfstat(kanfs_status, kanfs_bez, kanfs_isService) VALUES ('E', 'Erfolglos', TRUE);
    INSERT INTO kundanfstat(kanfs_status, kanfs_bez, kanfs_isService) VALUES ('L', 'Laufend', TRUE); --fix
    INSERT INTO kundanfstat(kanfs_status, kanfs_bez, kanfs_isService) VALUES ('NEU', 'Neu', FALSE); --fix
    INSERT INTO kundanfstat(kanfs_status, kanfs_bez, kanfs_isService) VALUES ('ANA', 'Analyse', FALSE);
    INSERT INTO kundanfstat(kanfs_status, kanfs_bez, kanfs_isService) VALUES ('BEA', 'Bearbeitung', FALSE);
    INSERT INTO kundanfstat(kanfs_status, kanfs_bez, kanfs_isService) VALUES ('RUC', 'Rückmeldung', FALSE);
    INSERT INTO kundanfstat(kanfs_status, kanfs_bez, kanfs_isService) VALUES ('GES', 'Geschlossen', FALSE);

     --Priorität
    INSERT INTO kundanfprio(kanfpr_prio, kanfpr_bez, kanfpr_isService) VALUES ('s1', 'hoch', TRUE);
    INSERT INTO kundanfprio(kanfpr_prio, kanfpr_bez, kanfpr_isService) VALUES ('s2', 'mittel', TRUE);
    INSERT INTO kundanfprio(kanfpr_prio, kanfpr_bez, kanfpr_isService) VALUES ('s3', 'niedrig', TRUE);
    INSERT INTO kundanfprio(kanfpr_prio, kanfpr_bez, kanfpr_isService) VALUES ('k1', 'sehr wichtig', FALSE);
    INSERT INTO kundanfprio(kanfpr_prio, kanfpr_bez, kanfpr_isService) VALUES ('k2', 'wichtig', FALSE);
    INSERT INTO kundanfprio(kanfpr_prio, kanfpr_bez, kanfpr_isService) VALUES ('k3', 'normal', FALSE);

    --Realisierungswahrscheinlichkeit
    INSERT INTO kanfwsk(kanfwsk_wsk, kanfwsk_bez) VALUES ('R1', 'Hoch');
    INSERT INTO kanfwsk(kanfwsk_wsk, kanfwsk_bez) VALUES ('R2', 'Mittel');
    INSERT INTO kanfwsk(kanfwsk_wsk, kanfwsk_bez) VALUES ('R3', 'Niedrig');

     --Anfrageart
    INSERT INTO kundanfart(kanfart_status, kanfart_bez) VALUES ('MV', 'Materialverkauf');
    INSERT INTO kundanfart(kanfart_status, kanfart_bez) VALUES ('G', 'Großkunde');
    INSERT INTO kundanfart(kanfart_status, kanfart_bez, kanfart_isService) VALUES ('ES', 'Externe Serviceanfrage', TRUE);
    INSERT INTO kundanfart(kanfart_status, kanfart_bez, kanfart_isService) VALUES ('IS', 'Interne Serviceanfrage', TRUE);  -- ID hat Verwendung in Funktion doABK
    INSERT INTO kundanfart(kanfart_status, kanfart_bez, kanfart_isService) VALUES ('A', 'Interessentenakquise', FALSE);

     --Absagegrund-Gruppe
    INSERT INTO kundabs(kanfa_grup, kanfa_bez) VALUES ('VERSCHOBEN', 'Späterer Zeitpunkt');
    INSERT INTO kundabs(kanfa_grup, kanfa_bez) VALUES ('WETTBEWERBER', 'Wettbewerber');

    --Herkunfts-Gruppe
    INSERT INTO kundhkg(kanfh_grup, kanfh_bez) VALUES ('AK', 'Altkunde');
    INSERT INTO kundhkg(kanfh_grup, kanfh_bez) VALUES ('E', 'Empfehlung');
    INSERT INTO kundhkg(kanfh_grup, kanfh_bez) VALUES ('I', 'Internet');
    INSERT INTO kundhkg(kanfh_grup, kanfh_bez) VALUES ('PR', 'Presse');

    --Gesendet via
    INSERT INTO kundgv(kanfv_via, kanfv_bez) VALUES ('EMAIL', 'E-Mail');
    INSERT INTO kundgv(kanfv_via, kanfv_bez) VALUES ('FAX', 'Fax');
    INSERT INTO kundgv(kanfv_via, kanfv_bez) VALUES ('POST', 'Postalisch');
    INSERT INTO kundgv(kanfv_via, kanfv_bez) VALUES ('PERS', 'Persönlich');


    --Ergebnis der Ausschreibung
    INSERT INTO kundaerg(kanfe_erg, kanfe_bez) VALUES ('A', 'Auftrag erteilt');
    INSERT INTO kundaerg(kanfe_erg, kanfe_bez) VALUES ('E', 'Erfolglos');
--

--Vorgabe Artikelpruefungen
    INSERT INTO artPruefungVorgabe (aprv_id, aprv_bez, aprv_eing, aprv_ausg, aprv_web) VALUES (0, 'Qualitätszeugnisse prüfen', TRUE, TRUE, TRUE);

-- Vorgabe Artikelsuchbegriffe

    INSERT INTO art_search (aks_terms) VALUES ('Schraube');
    INSERT INTO art_search (aks_terms) VALUES ('Mutter');
    INSERT INTO art_search (aks_terms) VALUES ('Kabel');
    INSERT INTO art_search (aks_terms) VALUES ('Flansch');
    INSERT INTO art_search (aks_terms) VALUES ('Kupplung');
    INSERT INTO art_search (aks_terms) VALUES ('Rohr');
    INSERT INTO art_search (aks_terms) VALUES ('Bolzen');
    INSERT INTO art_search (aks_terms) VALUES ('Gehäuse');
    INSERT INTO art_search (aks_terms) VALUES ('Widerstand');

-- DMS

    -- DevExpress PDF Viewer: Default
        INSERT INTO settings (s_vari, s_inha) VALUES ('PreviewDocumentModules', 'PDF-DEVEXPRESS');

    -- Dokumentenbäume: Grundbaum
  DO $$
  DECLARE
    tid INTEGER;
    nid0 INTEGER;
    nid1 INTEGER;
    nid2 INTEGER;
  BEGIN
    --SELECT dtl_id INTO tid FROM dokutrees WHERE dtl_tablename IS NULL;
    INSERT INTO dokutrees (dtl_description, dtl_tablename)
    VALUES ('Grundbaum', NULL) RETURNING dtl_id INTO tid;

    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 0,    NULL, NULL, 'Wurzel',                1)   RETURNING dtn_id INTO nid0;

    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 1,    nid0, 100,  'AVOR',                  151) RETURNING dtn_id INTO nid1;
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 2,    nid1, NULL, 'sonstiges',             151);

    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 3,    nid0, 200,  'QS',                    151) RETURNING dtn_id INTO nid1;
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 4,    nid1, 10,   'Beanstandungen',        151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 5,    nid1, 50,   'Erstbemusterung',       151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 6,    nid1, 40,   'Schriftverkehr',        151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 7,    nid1, 30,   'Messprotokolle',        151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 32,   nid1, 20,   'Zeugnis',               151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 33,   nid1, 60,   'Erstmusterprüfbericht', 151);

    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 8,    nid0, 300,  'Einkauf',               151) RETURNING dtn_id INTO nid1;
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 9,    nid1, 10,   'Angebote',              151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 28,   nid1, 20,   'Bestellungen',          151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 104,   nid1, 22,   'Bestellbestätigungen des Lieferanten',          151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 29,   nid1, 30,   'Auswärtsvergaben',      151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 30,   nid1, 40,   'Lieferscheine',         151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 31,   nid1, 50,   'Rechnungen',            151);
                --32 siehe oben
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 10,   nid0, 400,  'Verkauf/Marketing',     151) RETURNING dtn_id INTO nid1;
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 11,   nid1, 10,   'Angebote',              151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 24,   nid1, 50,   'Nachkalkulationen',     151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 25,   nid1, 20,   'Bestellungen',          151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 215,   nid1, 25,   'Kundenreklamationen',          151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 26,   nid1, 30,   'Lieferscheine',         151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 27,   nid1, 40,   'Rechnungen',            151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 204,  nid1, 11,   'Auftragsbestätigungen an Kunden',   151);

    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 12,   nid0, 500,  'Fertigung',             151) RETURNING dtn_id INTO nid1;
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 13,   nid1, NULL, 'ABK',                   151);

    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 14,   nid0, 600,  'Dokumente',             151) RETURNING dtn_id INTO nid1;
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 15,   nid1, NULL, 'Zeichnungen',           151) RETURNING dtn_id INTO nid2;
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 16,   nid2, NULL, 'Ungültige Versionen',   151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 17,   nid1, NULL, 'Stückliste',            151) RETURNING dtn_id INTO nid2;
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 18,   nid2, NULL, 'Ungültige Versionen',   151);
   -- INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image) --PHKO #11424
   -- VALUES (tid, 19,   nid2, NULL, 'Stücklisten - Ungültige Versionen', 151); --PHKO #11424
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 20,   nid1, NULL, 'Datenblätter',          151) RETURNING dtn_id INTO nid2;
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 21,   nid2, NULL, 'Ungültige Versionen',   151);
    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 22,   nid1, NULL, 'Änderungsaufträge',     151);

    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 23,   nid0, 700,  'Bilder',                151);

    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 40,   nid0, 550,  'Projekt',               151);

    INSERT INTO dokutreenodes (dtn_dtl_id, dtn_nodeid, dtn_parentid, dtn_position, dtn_caption, dtn_image)
    VALUES (tid, 50,   nid0, 900,  'Ausgegebene Dokumente', 5);

    RETURN;
  END
  $$ LANGUAGE plpgsql;


-- ItemTypes (CompOption/GridFilter/HelpIndex)
    INSERT INTO itemtypes (it_type, it_table, it_idfield, it_itemfield, it_deletedfield, it_groupname, it_itemname, it_description) VALUES ('CompOption', 'component_options', 'co_id', 'co_item', NULL,         'FormClass', 'Component', 'Einstellungen für Komponenten');
    INSERT INTO itemtypes (it_type, it_table, it_idfield, it_itemfield, it_deletedfield, it_groupname, it_itemname, it_description) VALUES ('GridFilter', 'gridfilter',        'gf_id', 'gf_item', 'gf_deleted', 'FormClass', 'GridView',  'Filter für CimGridView');
    INSERT INTO itemtypes (it_type, it_table, it_idfield, it_itemfield, it_deletedfield, it_groupname, it_itemname, it_description) VALUES ('GridLayout', 'gridlayout',        'gl_id', 'gl_item', 'gl_deleted', 'FormClass', 'GridView',  'Layout für CimGridView');
    INSERT INTO itemtypes (it_type, it_table, it_idfield, it_itemfield, it_deletedfield, it_groupname, it_itemname, it_description) VALUES ('HelpComp',   'helpindex',         'hi_id', 'hi_item', 'hi_deleted', 'FormClass', 'Component', 'Hilfelink für Komponente');
    INSERT INTO itemtypes (it_type, it_table, it_idfield, it_itemfield, it_deletedfield, it_groupname, it_itemname, it_description) VALUES ('HelpIndex',  'helpindex',         'hi_id', 'hi_item', 'hi_deleted', 'IndexName', NULL,        'Hilfelink für Indexname');
--


-- EAV
    -- PrintSettings
        INSERT INTO recnogroup(reg_gruppe, reg_tablename, reg_pname, reg_bez_textno, reg_paramtype)
               SELECT 'System', NULL, 'System.Printing', 26109, 'ptVARCHAR'
               WHERE NOT EXISTS (SELECT TRUE FROM recnogroup WHERE reg_pname='System.Printing');
    -- Artikel
        INSERT INTO recnogroup (reg_tablename, reg_gruppe, reg_bez, reg_pname) VALUES
        ('art', 'Bearbeitungsstatus', 'Überarbeitungsstatus', 'Bearbeitungsstatus.Überarbeitungsstatus'),
        ('art', 'Bearbeitungsstatus', 'Prüfstatus', 'Bearbeitungsstatus.Prüfstatus');

    -- E-Shelf-Label
        INSERT INTO recnogroup (reg_pos, reg_pname, reg_tablename, reg_bez, reg_gruppe, reg_vorgabenliste, reg_paramtype, reg_autoinsert, reg_visible) VALUES
        (1, 'art.esl.model',    'art', 'ESL Model',   'ESL', False, 'ptVARCHAR', False, True),
        (2, 'art.esl.width',    'art', 'ESL Breite',  'ESL', False, 'ptNUMERIC', False, True),
        (3, 'art.esl.height',   'art', 'ESL Höhe',    'ESL', False, 'ptNUMERIC', False, True),
        (4, 'art.esl.rotation', 'art', 'ESL Drehung', 'ESL', False, 'ptNUMERIC', False, True),
        (5, 'art.esl.color',    'art', 'ESL Farbe',   'ESL', False, 'ptVARCHAR', False, True);
    --

    -- Adressverwaltung / ADK: Geheimhaltungsvereinbarung usw.
        INSERT INTO recnogroup (reg_tablename, reg_gruppe, reg_bez, reg_pname, reg_paramtype, reg_default, reg_visible) VALUES
        ('adk', 'Lieferantenüberwachung', 'Geheimhaltungsvereinbarung: versendet und gescannt', 'Lieferant.Geheimhaltungsvereinbarung', 'ptTRISTATEBOOLEAN', 'False', True),
        ('adk', 'Lieferantenüberwachung', 'Selbstauskunft: versendet und gescannt', 'Lieferant.Selbstauskunft', 'ptTRISTATEBOOLEAN', 'False', True);

    -- Druck von Chargen- und Seriennummern auf Dokumenten
        INSERT INTO recnogroup (reg_tablename, reg_gruppe, reg_bez_textno, reg_pname, reg_paramtype, reg_default, reg_visible) VALUES
        ('adk', 'Zentraldokument', 28745, 'Zentraldokument.Charge', 'ptTRISTATEBOOLEAN', 'True', True),
        ('adk', 'Zentraldokument', 28744, 'Zentraldokument.Seriennummer', 'ptTRISTATEBOOLEAN', 'True', True);
    --

    -- Durchlaufzeiten (Auftrag)
        INSERT INTO recnogroup (reg_tablename, reg_gruppe, reg_bez, reg_bez_textno, reg_pname, reg_paramtype, reg_autoinsert) VALUES
        ('auftg', 'Durchlaufzeiten', 'Gesamtzeit (Bestelldatum > Lieferschein, Tage)', 20128, 'auftg.dlz.Summe', 'ptINTEGER', true),            -- Gesamtzeit (Bestelldatum > Lieferschein, Tage)
        ('auftg', 'Durchlaufzeiten', 'Fertigungszeit (1. Stempelung > Lieferschein, Tage)', 20129, 'auftg.dlz.Fertigung', 'ptINTEGER', true),   -- Vorlaufzeit (Bestelldatum > 1. Stempelung, Tage)
        ('auftg', 'Durchlaufzeiten', 'Vorlaufzeit (Bestelldatum > 1. Stempelung, Tage)', 20130, 'auftg.dlz.Vorlauf', 'ptINTEGER', true);        -- Fertigungszeit (1. Stempelung > Lieferschein, Tage)
    --
    -- Rentabilität
        INSERT INTO recnogroup (reg_tablename, reg_gruppe, reg_bez, reg_bez_textno, reg_pname, reg_paramtype, reg_autoinsert) VALUES
        ('auftg', 'Rentabilität', 'Erlös' , 26094, 'auftg.rent.erl' , 'ptNUMERIC', false),
        ('auftg', 'Rentabilität', 'Kosten',  3213, 'auftg.rent.kost', 'ptNUMERIC', false),
        ('auftg', 'Rentabilität', 'Prüfer', 30058, 'auftg.rent.user', 'ptNUMERIC', false);
    --

    -- Freigabe Status Ausschuss, Gelangsbestätigung (wieso vermischt?!)
        INSERT INTO recnogroup (reg_tablename, reg_gruppe, reg_bez, reg_bez_textno, reg_pname, reg_paramtype, reg_visible) VALUES
        ('abk', 'System', 'Freigabemenge Unterproduktion', 26104, 'System.Freigabemenge.Unterproduktion', 'ptNUMERIC', false),                       -- Freigabemenge Unterproduktion
        ('abk', 'System', 'Quittierung Unterproduktion', 16531, 'System.Quittierung.Unterproduktion', 'ptTRISTATEBOOLEAN', false),                   -- Quittierung Unterproduktion
        ('belegdokument', 'System', 'Gelangensbestätigung: Unterschrift erhalten', 26107, 'System.Gelangensbestätigung', 'ptTRISTATEBOOLEAN', true); -- Gelangensbestätigung
    --
    /*
    #5381 Auftragsbearbeitung LOLL
    INSERT INTO recnogroup(reg_pos, reg_gruppe, reg_tablename, reg_pname, reg_bez, reg_bez_textno, reg_paramtype) SELECT 10, 'Auftragsbearbeitung', 'auftg', 'auftg.bearbtg.p1', 'Preisprüfung', 25078, 'ptBOOLEAN';
    INSERT INTO recnogroup(reg_pos, reg_gruppe, reg_tablename, reg_pname, reg_bez, reg_bez_textno, reg_paramtype) SELECT 20, 'Auftragsbearbeitung', 'auftg', 'auftg.bearbtg.p2', 'Materialverfügbarkeit', 25091, 'ptBOOLEAN';
    INSERT INTO recnogroup(reg_pos, reg_gruppe, reg_tablename, reg_pname, reg_bez, reg_bez_textno, reg_paramtype) SELECT 30, 'Auftragsbearbeitung', 'auftg', 'auftg.bearbtg.p3', 'Indexprüfung', 25092, 'ptBOOLEAN';
    INSERT INTO recnogroup(reg_pos, reg_gruppe, reg_tablename, reg_pname, reg_bez, reg_bez_textno, reg_paramtype) SELECT 40, 'Auftragsbearbeitung', 'auftg', 'auftg.bearbtg.p4', 'Vorabeinplanung', 25093, 'ptBOOLEAN';
    INSERT INTO recnogroup(reg_pos, reg_gruppe, reg_tablename, reg_pname, reg_bez, reg_paramtype) SELECT 50, 'Auftragsbearbeitung', 'auftg', 'auftg.bearbtg.p5', '3D-Modell', 'ptBOOLEAN';
    INSERT INTO recnogroup(reg_pos, reg_gruppe, reg_tablename, reg_pname, reg_bez, reg_bez_textno, reg_paramtype) SELECT 60, 'Auftragsbearbeitung', 'auftg', 'auftg.bearbtg.p6', 'Erledigt', 29322, 'ptBOOLEAN';
    INSERT INTO recnogroup(reg_pos, reg_gruppe, reg_tablename, reg_pname, reg_bez, reg_paramtype) SELECT 100, 'Auftragsbearbeitung', 'auftg', 'auftg.bearbtg.AVORzust', 'Übernommen zum Auflegen (ABK) durch', 'ptVARCHAR'; -- #8067
    */

    -- Auftragsbearbeitung allgemein seit #19393
    -- DELETE FROM recnogroup WHERE reg_gruppe = 'Auftragsbearbeitung';
    INSERT INTO recnogroup
    (reg_pos, reg_gruppe, reg_tablename, reg_pname, reg_bez, reg_bez_textno, reg_paramtype)
    VALUES
    (10, 'Auftragsbearbeitung', 'auftg', 'auftg.bearbtg.preis', 'Preisprüfung', 25078, 'ptBOOLEAN'),
    (20, 'Auftragsbearbeitung', 'auftg', 'auftg.bearbtg.zeichnung', 'Zeichnungsprüfung', 25092, 'ptBOOLEAN'),
    (30, 'Auftragsbearbeitung', 'auftg', 'auftg.bearbtg.AVORzust', 'Übernommen zum Auflegen (ABK) durch', 29118, 'ptVARCHAR'),
    (40, 'Auftragsbearbeitung', 'auftg', 'auftg.bearbtg.erledigt', 'Erledigt', 29322, 'ptBOOLEAN') --manuelles entfernen aus der Liste ermöglichen, wenn nicht durch WHERE möglich
    ;
    --- #19849 View 'trecnoparam.pivot__by__auftg_auftragsbearbeitung__view' erstellen
    SELECT TRecnoParam.pivot_view__by__tablename_reggroup__recreate( 'auftg', 'Auftragsbearbeitung', 'cimgreen' );
    ---

    -- CAD Statis
        INSERT INTO recnogroup
        (reg_bez, reg_gruppe, reg_default, reg_paramtype, reg_tablename, reg_pname, reg_pos)
        VALUES
        ('Artikelstatus', 'CAD', '', 'ptENUM', 'art', 'art.status.cad', 1);

        INSERT INTO recnoenums
        (rege_reg_pname, rege_code, rege_bez                     , rege_pos)
        VALUES
        ('art.status.cad', 'I', 'Eingecheckt (checked In)'       , -2),
        ('art.status.cad', 'O', 'Ausgecheckt (checked Out)'      , -1),
        ('art.status.cad', 'P', 'Erstellt (Prepared)'            ,  1),
        ('art.status.cad', 'C', 'Geprüft (Checked)'              ,  2),
        ('art.status.cad', 'A', 'Freigegeben (Approved)'         ,  3);

        -- CAD Dokumenten-Statis
        INSERT INTO recnogroup
        (reg_bez, reg_gruppe, reg_default, reg_paramtype, reg_tablename, reg_pname, reg_pos)
        VALUES
        ('CAD-Dokumentenstatus', 'CAD', '', 'ptENUM', 'art', 'dms.status.cad', 1);

        INSERT INTO recnoenums
        (rege_reg_pname, rege_code, rege_bez                              , rege_pos)
        VALUES
        ('dms.status.cad', 'T', 'Aus Vorlage kopiert (copy from Template)', 1),
        ('dms.status.cad', 'F', 'Anhand Datei kopiert (copy from File)'   , 2),
        ('dms.status.cad', 'D', 'Zum DMS hinzugefügt (linked with DMS)'   , 3),
        ('dms.status.cad', 'O', 'Ausgecheckt (checked Out)'               , 4),
        ('dms.status.cad', 'S', 'Synchronisiert (Synchronized)'           , 5);

    -- Gefahrgut Eigenschaften für Artikelstamm
        INSERT INTO recnogroup
         (reg_tablename, reg_gruppe, reg_gruppe_textno, reg_bez, reg_bez_textno, reg_paramtype, reg_pname, reg_field_name, reg_field_value, reg_autoinsert, reg_exclusive)
        VALUES
         ('art', 'Gefahrgut', 27057, 'STOT Bewertung', 29836, 'ptENUM', 'ak_gefahrgut.stot', 'ak_gefahrgut', 'true', true, false),
         ('art', 'Gefahrgut', 27057, 'Gefahrenhinweis', 27065, 'ptENUM', 'ak_gefahrgut.hinweis', 'ak_gefahrgut', 'true', true, false),
         ('art', 'Gefahrgut', 27057, 'Signalwort', 27066, 'ptENUM', 'ak_gefahrgut.signalwort', 'ak_gefahrgut', 'true', true, true),
         ('art', 'Gefahrgut', 27057, 'Gefahrenpiktogramm', 27067, 'ptENUM', 'ak_gefahrgut.piktogramm', 'ak_gefahrgut', 'true', true, false),
         ('art', 'Gefahrgut', 27057, 'Sicherheitshinweis ', 27068, 'ptENUM', 'ak_gefahrgut.sicherheit', 'ak_gefahrgut', 'true', true, false),
         ('art', 'Gefahrgut', 27057, 'Gefahrenmerkmal ', 27069, 'ptENUM', 'ak_gefahrgut.merkmal', 'ak_gefahrgut', 'true', true, false),
         ('art', 'Gefahrgut', 27057, 'Verwendung in Abteilung', 27088, 'ptVARCHAR', 'ak_gefahrgut.bereich', 'ak_gefahrgut', 'true', true, false),
         ('art', 'Gefahrgut', 27057, 'Anzahl Personen mit Umgang', 27089, 'ptNUMERIC', 'ak_gefahrgut.anz_personen', 'ak_gefahrgut', 'true', true, false),
         ('art', 'Gefahrgut', 27057, 'CMR stoff', 27090, 'ptBOOLEAN', 'ak_gefahrgut.CMR_stoff', 'ak_gefahrgut', 'true', true, true),
         ('art', 'Gefahrgut', 27057, 'CMR Klasse', 29895, 'ptENUM', 'ak_gefahrgut.CMR_klasse', 'ak_gefahrgut', 'true', true, true),
         ('art', 'Gefahrgut', 27057, 'CMR Ersatzbeurteilung', 27091, 'ptVARCHAR', 'ak_gefahrgut.CMR_ersatz', 'ak_gefahrgut', 'true', true, true),
         ('art', 'Gefahrgut', 27057, 'Wassergefährdungsklasse', 27221, 'ptENUM', 'ak_gefahrgut.wassergefaehrdungsklasse', 'ak_gefahrgut', 'true', true, true),
         ('art', 'Gefahrgut', 27057, 'Sicherheitsdatenblatt vom:', 27222, 'ptDATE', 'ak_gefahrgut.sdb', 'ak_gefahrgut', 'true', true, true),
         ('art', 'Gefahrgut', 27057, 'Sicherheitsdatenblatt geprüft am', 27226, 'ptDATE', 'ak_gefahrgut.sdb_pruef', 'ak_gefahrgut', 'true', true, true),
         ('art', 'Gefahrgut', 27057, 'Gefahrstofflagerklasse', 27225, 'ptENUM', 'ak_gefahrgut.gefahrstofflagerklassen', 'ak_gefahrgut', 'true', true, true),
         ('art', 'Gefahrgut', 27057, 'Gefährlicher Abfall', 28621, 'ptBOOLEAN', 'ak_gefahrgut.abfall', 'ak_gefahrgut', 'true', true, true);

        INSERT INTO recnoenums
         (rege_reg_pname, rege_code, rege_bez, rege_pos)
        VALUES
         ('ak_gefahrgut.hinweis', 'H200', 'Instabil, explosiv.', 1),
         ('ak_gefahrgut.hinweis', 'H201', 'Explosiv, Gefahr der Massenexplosion.', 2),
         ('ak_gefahrgut.hinweis', 'H202', 'Explosiv; große Gefahr durch Splitter, Spreng- und Wurfstücke.', 3),
         ('ak_gefahrgut.hinweis', 'H203', 'Explosiv; Gefahr durch Feuer, Luftdruck oder Splitter, Spreng- und Wurfstücke.', 4),
         ('ak_gefahrgut.hinweis', 'H204', 'Gefahr durch Feuer oder Splitter, Spreng- und Wurfstücke.', 5),
         ('ak_gefahrgut.hinweis', 'H205', 'Gefahr der Massenexplosion bei Feuer.', 6),
         ('ak_gefahrgut.hinweis', 'H206', 'Gefahr durch Feuer, Druckstoß oder Sprengstücke; erhöhte Explosionsgefahr, wenn das Desensibilisieru'::varchar(100), 7),
         ('ak_gefahrgut.hinweis', 'H207', 'Gefahr durch Feuer oder Sprengstücke; erhöhte Explosionsgefahr, wenn das Desensibilisierungsmittel '::varchar(100), 8),
         ('ak_gefahrgut.hinweis', 'H208', 'Gefahr durch Feuer; erhöhte Explosionsgefahr, wenn das Desensibilisierungsmittel reduziert wird.', 9),
         ('ak_gefahrgut.hinweis', 'H220', 'Extrem entzündbares Gas.', 10),
         ('ak_gefahrgut.hinweis', 'H221', 'Entzündbares Gas.', 11),
         ('ak_gefahrgut.hinweis', 'H222', 'Extrem entzündbares Aerosol.', 12),
         ('ak_gefahrgut.hinweis', 'H223', 'Entzündbares Aerosol.', 13),
         ('ak_gefahrgut.hinweis', 'H224', 'Flüssigkeit und Dampf extrem entzündbar.', 14),
         ('ak_gefahrgut.hinweis', 'H225', 'Flüssigkeit und Dampf leicht entzündbar.', 15),
         ('ak_gefahrgut.hinweis', 'H226', 'Flüssigkeit und Dampf entzündbar.', 16),
         ('ak_gefahrgut.hinweis', 'H228', 'Entzündbarer Feststoff.', 17),
         ('ak_gefahrgut.hinweis', 'H229', 'Behälter steht unter Druck: Kann bei Erwärmung bersten.', 18),
         ('ak_gefahrgut.hinweis', 'H230', 'Kann auch in Abwesenheit von Luft explosionsartig reagieren.', 19),
         ('ak_gefahrgut.hinweis', 'H231', 'Kann auch in Abwesenheit von Luft bei erhöhtem Druck und/oder erhöhter Temperatur explosionsartig re'::varchar(100), 20),
         ('ak_gefahrgut.hinweis', 'H232', 'Kann sich bei Kontakt mit Luft spontan entzünden.', 21),
         ('ak_gefahrgut.hinweis', 'H240', 'Erwärmung kann Explosion verursachen.', 22),
         ('ak_gefahrgut.hinweis', 'H241', 'Erwärmung kann Brand oder Explosion verursachen.', 23),
         ('ak_gefahrgut.hinweis', 'H242', 'Erwärmung kann Brand verursachen.', 24),
         ('ak_gefahrgut.hinweis', 'H250', 'Entzündet sich in Berührung mit Luft von selbst.', 25),
         ('ak_gefahrgut.hinweis', 'H251', 'Selbsterhitzungsfähig; kann in Brand geraten.', 26),
         ('ak_gefahrgut.hinweis', 'H252', 'In großen Mengen selbsterhitzungsfähig; kann in Brand geraten.', 27),
         ('ak_gefahrgut.hinweis', 'H260', 'In Berührung mit Wasser entstehen entzündbare Gase, die sich spontan entzünden können.', 28),
         ('ak_gefahrgut.hinweis', 'H261', 'In Berührung mit Wasser entstehen entzündbare Gase.', 29),
         ('ak_gefahrgut.hinweis', 'H270', 'Kann Brand verursachen oder verstärken; Oxidationsmittel.', 30),
         ('ak_gefahrgut.hinweis', 'H271', 'Kann Brand oder Explosion verursachen; starkes Oxidationsmittel.', 31),
         ('ak_gefahrgut.hinweis', 'H272', 'Kann Brand verstärken; Oxidationsmittel.', 32),
         ('ak_gefahrgut.hinweis', 'H280', 'Enthält Gas unter Druck; kann bei Erwärmung explodieren.', 33),
         ('ak_gefahrgut.hinweis', 'H281', 'Enthält tiefgekühltes Gas; kann Kälteverbrennungen oder Verletzungen verursachen.', 34),
         ('ak_gefahrgut.hinweis', 'H290', 'Kann gegenüber Metallen korrosiv sein.', 35),
         ('ak_gefahrgut.hinweis', 'H300', 'Lebensgefahr bei Verschlucken.', 36),
         ('ak_gefahrgut.hinweis', 'H301', 'Giftig bei Verschlucken.', 37),
         ('ak_gefahrgut.hinweis', 'H302', 'Gesundheitsschädlich bei Verschlucken.', 38),
         ('ak_gefahrgut.hinweis', 'H304', 'Kann bei Verschlucken und Eindringen in die Atemwege tödlich sein.', 39),
         ('ak_gefahrgut.hinweis', 'H310', 'Lebensgefahr bei Hautkontakt.', 40),
         ('ak_gefahrgut.hinweis', 'H311', 'Giftig bei Hautkontakt.', 41),
         ('ak_gefahrgut.hinweis', 'H312', 'Gesundheitsschädlich bei Hautkontakt.', 42),
         ('ak_gefahrgut.hinweis', 'H314', 'Verursacht schwere Verätzungen der Haut und schwere Augenschäden.', 43),
         ('ak_gefahrgut.hinweis', 'H315', 'Verursacht Hautreizungen.', 44),
         ('ak_gefahrgut.hinweis', 'H317', 'Kann allergische Hautreaktionen verursachen.', 45),
         ('ak_gefahrgut.hinweis', 'H318', 'Verursacht schwere Augenschäden.', 46),
         ('ak_gefahrgut.hinweis', 'H319', 'Verursacht schwere Augenreizung.', 47),
         ('ak_gefahrgut.hinweis', 'H330', 'Lebensgefahr bei Einatmen.', 48),
         ('ak_gefahrgut.hinweis', 'H331', 'Giftig bei Einatmen.', 49),
         ('ak_gefahrgut.hinweis', 'H332', 'Gesundheitsschädlich bei Einatmen.', 50),
         ('ak_gefahrgut.hinweis', 'H334', 'Kann bei Einatmen Allergie, asthmaartige Symptome oder Atembeschwerden verursachen.', 51),
         ('ak_gefahrgut.hinweis', 'H335', 'Kann die Atemwege reizen.', 52),
         ('ak_gefahrgut.hinweis', 'H336', 'Kann Schläfrigkeit und Benommenheit verursachen.', 53),
         ('ak_gefahrgut.hinweis', 'H340', 'Kann genetische Defekte verursachen.', 54),
         ('ak_gefahrgut.hinweis', 'H3401', 'Kann bei Einatmen genetische Defekte verursachen.', 55),
         ('ak_gefahrgut.hinweis', 'H3402', 'Kann bei Hautkontakt genetische Defekte verursachen', 56),
         ('ak_gefahrgut.hinweis', 'H3403', 'Kann bei Verschlucken genetische Defekte verursachen', 57),
         ('ak_gefahrgut.hinweis', 'H341', 'Kann vermutlich genetische Defekte verursachen.', 58),
         ('ak_gefahrgut.hinweis', 'H3411', 'Kann bei Einatmen vermutlich genetische Defekte verursachen.', 59),
         ('ak_gefahrgut.hinweis', 'H3412', 'Kann bei Hautkontakt vermutlich genetische Defekte verursachen.', 60),
         ('ak_gefahrgut.hinweis', 'H3413', 'Kann bei Verschlucken vermutlich genetische Defekte verursachen.', 61),
         ('ak_gefahrgut.hinweis', 'H350', 'Kann Krebs erzeugen.', 62),
         ('ak_gefahrgut.hinweis', 'H3501', 'Kann bei Hautkontakt Krebs erzeugen.', 63),
         ('ak_gefahrgut.hinweis', 'H3502', 'Kann bei Verschlucken Krebs erzeugen.', 64),
         ('ak_gefahrgut.hinweis', 'H350i', 'Kann bei Einatmen Krebs erzeugen.', 65),
         ('ak_gefahrgut.hinweis', 'H351', 'Kann vermutlich Krebs erzeugen.', 66),
         ('ak_gefahrgut.hinweis', 'H3511', 'Kann bei Einatmen vermutlich Krebs erzeugen.', 67),
         ('ak_gefahrgut.hinweis', 'H3512', 'Kann bei Hautkontakt vermutlich Krebs erzeugen.', 68),
         ('ak_gefahrgut.hinweis', 'H3513', 'Kann bei Verschlucken vermutlich Krebs erzeugen.', 69),
         ('ak_gefahrgut.hinweis', 'H360', 'Kann die Fruchtbarkeit beeinträchtigen oder das Kind im Mutterleib schädigen.', 70),
         ('ak_gefahrgut.hinweis', 'H360A', 'Kann die Fruchtbarkeit beeinträchtigen. Kann das Kind im Mutterleib schädigen.', 71),
         ('ak_gefahrgut.hinweis', 'H360B', 'Kann die Fruchtbarkeit beeinträchtigen.', 72),
         ('ak_gefahrgut.hinweis', 'H360C', 'Kann das Kind im Mutterleib schädigen.', 73),
         ('ak_gefahrgut.hinweis', 'H360D', 'Kann die Fruchtbarkeit beeinträchtigen. Kann vermutlich das Kind im Mutterleib schädigen.', 74),
         ('ak_gefahrgut.hinweis', 'H360E', 'Kann das Kind im Mutterleib schädigen. Kann vermutlich die Fruchtbarkeit beeinträchtigen.', 75),
         ('ak_gefahrgut.hinweis', 'H361', 'Kann vermutlich die Fruchtbarkeit beeinträchtigen oder das Kind im Mutterleib schädigen.', 76),
         ('ak_gefahrgut.hinweis', 'H361A', 'Kann vermutlich die Fruchtbarkeit beeinträchtigen. Kann vermutlich das Kind im Mutterleib schädigen.'::varchar(100), 77),
         ('ak_gefahrgut.hinweis', 'H361B', 'Kann vermutlich die Fruchtbarkeit beeinträchtigen.', 78),
         ('ak_gefahrgut.hinweis', 'H361C', 'Kann vermutlich das Kind im Mutterleib schädigen.', 79),
         ('ak_gefahrgut.hinweis', 'H362', 'Kann Säuglinge über die Muttermilch schädigen.', 80),
         ('ak_gefahrgut.hinweis', 'H370', 'Schädigt die Organe.', 81),
         ('ak_gefahrgut.hinweis', 'H3701', 'Schädigt bei Einatmen die Leber.', 82),
         ('ak_gefahrgut.hinweis', 'H3702', 'Schädigt bei Einatmen die Nieren.', 83),
         ('ak_gefahrgut.hinweis', 'H3703', 'Schädigt bei Einatmen das Herz.', 84),
         ('ak_gefahrgut.hinweis', 'H3704', 'Schädigt bei Hautkontakt die Leber.', 85),
         ('ak_gefahrgut.hinweis', 'H3705', 'Schädigt bei Hautkontakt die Nieren.', 86),
         ('ak_gefahrgut.hinweis', 'H3706', 'Schädigt bei Hautkontakt das Herz.', 87),
         ('ak_gefahrgut.hinweis', 'H3707', 'Schädigt bei Verschlucken die Leber.', 88),
         ('ak_gefahrgut.hinweis', 'H3708', 'Schädigt bei Verschlucken die Nieren.', 89),
         ('ak_gefahrgut.hinweis', 'H3709', 'Schädigt bei Verschlucken das Herz.', 90),
         ('ak_gefahrgut.hinweis', 'H371', 'Kann die Organe schädigen.', 91),
         ('ak_gefahrgut.hinweis', 'H372', 'Schädigt die Organe.', 92),
         ('ak_gefahrgut.hinweis', 'H373', 'Kann die Organe schädigen.', 93),
         ('ak_gefahrgut.hinweis', 'H400', 'Sehr giftig für Wasserorganismen mit langfristiger Wirkung.', 94),
         ('ak_gefahrgut.hinweis', 'H410', 'Sehr giftig für Wasserorganismen.', 95),
         ('ak_gefahrgut.hinweis', 'H411', 'Giftig für Wasserorgamismen mit langfristiger Wirkung.', 96),
         ('ak_gefahrgut.hinweis', 'H412', 'Schädlich für Wassserorganismen mit langfristiger Wirkung.', 97),
         ('ak_gefahrgut.hinweis', 'H413', 'Kann für Wasserorganismen schädlich sein mit langfristiger Wirkung.', 98),
         ('ak_gefahrgut.hinweis', 'H420', 'Schädigt die öffentliche Gesundheit und die Umwelt durch Ozonabbau in der äußeren Atmosphäre.'::varchar(100), 99);

        INSERT INTO recnoenums
         (rege_reg_pname, rege_code, rege_bez, rege_pos)
        VALUES
         ('ak_gefahrgut.signalwort', 'WNG', 'Achtung', 1),
         ('ak_gefahrgut.signalwort', 'DGR', 'Gefahr', 2);

        INSERT INTO recnoenums
         (rege_reg_pname, rege_code, rege_bez, rege_pos)
        VALUES
         ('ak_gefahrgut.stot', 'SE 1', 'einmalige Exposition', 1),
         ('ak_gefahrgut.stot', 'SE 2', 'einmalige Exposition', 2),
         ('ak_gefahrgut.stot', 'SE 3', 'einmalige Exposition', 3),
         ('ak_gefahrgut.stot', 'RE 1', 'wiederholte Exposition', 4),
         ('ak_gefahrgut.stot', 'RE 2', 'wiederholte Exposition', 5);

        INSERT INTO recnoenums
         (rege_reg_pname, rege_code, rege_bez, rege_pos)
        VALUES
        ('ak_gefahrgut.piktogramm', 'GHS01', 'Explodierende Bombe', 1),
        ('ak_gefahrgut.piktogramm', 'GHS02', 'Flamme', 2),
        ('ak_gefahrgut.piktogramm', 'GHS03', 'Flamme über einem Kreis', 3),
        ('ak_gefahrgut.piktogramm', 'GHS04', 'Gasflasche', 4),
        ('ak_gefahrgut.piktogramm', 'GHS05', 'Ätzwirkung', 5),
        ('ak_gefahrgut.piktogramm', 'GHS06', 'Totenkopf mit gekreuzten Knochen', 6),
        ('ak_gefahrgut.piktogramm', 'GHS07', 'Ausrufezeichen', 7),
        ('ak_gefahrgut.piktogramm', 'GHS08', 'Gesundheitsgefahr', 8),
        ('ak_gefahrgut.piktogramm', 'GHS09', 'Umwelt', 9);

        INSERT INTO recnoenums
         (rege_reg_pname, rege_code, rege_bez, rege_pos)
        VALUES
        ('ak_gefahrgut.sicherheit', 'P101', 'Ist ärztlicher Rat erforderlich, Verpackung oder Kennzeichnungsetikett bereithalten.'::varchar(100), 1),
        ('ak_gefahrgut.sicherheit', 'P102', 'Darf nicht in die Hände von Kindern gelangen.', 2),
        ('ak_gefahrgut.sicherheit', 'P103', 'Lesen Sie sämtliche Anweisungen aufmerksam und befolgen Sie diese.', 3),
        ('ak_gefahrgut.sicherheit', 'P201', 'Vor Gebrauch besondere Anweisungen einholen.', 4),
        ('ak_gefahrgut.sicherheit', 'P202', 'Vor Gebrauch alle Sicherheitshinweise lesen und verstehen.', 5),
        ('ak_gefahrgut.sicherheit', 'P210', 'Von Hitze, heißen Oberflächen, Funken, offenen Flammen und anderen Zündquellen fernhalten. Nicht rau'::varchar(100), 6),
        ('ak_gefahrgut.sicherheit', 'P211', 'Nicht gegen offene Flamme oder andere Zündquelle sprühen.', 7),
        ('ak_gefahrgut.sicherheit', 'P212', 'Erhitzen unter Einschluss und Reduzierung des Desensibilisierungsmittels vermeiden.', 8),
        ('ak_gefahrgut.sicherheit', 'P220', 'Von Kleidung und anderen brennbaren Materialien fernhalten.', 9),
        ('ak_gefahrgut.sicherheit', 'P222', 'Keinen Kontakt mit Luft zulassen.', 10),
        ('ak_gefahrgut.sicherheit', 'P223', 'Keinen Kontakt mit Wasser zulassen.', 11),
        ('ak_gefahrgut.sicherheit', 'P230', 'Feucht halten mit ....', 12),
        ('ak_gefahrgut.sicherheit', 'P231', 'Inhalt unter inertem Gas/... handhaben und aufbewahren.', 14),
        ('ak_gefahrgut.sicherheit', 'P232', 'Vor Feuchtigkeit schützen.', 17),
        ('ak_gefahrgut.sicherheit', 'P233', 'Behälter dicht verschlossen halten.', 18),
        ('ak_gefahrgut.sicherheit', 'P234', 'Nur in Originalverpackung aufbewahren.', 19),
        ('ak_gefahrgut.sicherheit', 'P235', 'Kühl halten.', 20),
        ('ak_gefahrgut.sicherheit', 'P240', 'Behälter und zu befüllende Anlage erden.', 21),
        ('ak_gefahrgut.sicherheit', 'P241', 'Explosionsgeschützte [elektrische/Lüftungs-/Beleuchtungs-/...] Geräte verwenden.'::varchar(100), 22),
        ('ak_gefahrgut.sicherheit', 'P242', 'Funkenarmes Werkzeug verwenden.', 26),
        ('ak_gefahrgut.sicherheit', 'P243', 'Maßnahmen gegen elektrostatische Entladungen treffen.', 27),
        ('ak_gefahrgut.sicherheit', 'P244', 'Ventile und Ausrüstungsteile öl- und fettfrei halten.', 28),
        ('ak_gefahrgut.sicherheit', 'P250', 'Nicht schleifen/stoßen/reiben/....', 29),
        ('ak_gefahrgut.sicherheit', 'P251', 'Nicht durchstechen oder verbrennen, auch nicht nach Gebrauch.', 33),
        ('ak_gefahrgut.sicherheit', 'P260', 'Staub/Rauch/Gas/Nebel/Dampf/Aerosol nicht einatmen.', 34),
        ('ak_gefahrgut.sicherheit', 'P261', 'Einatmen von Staub/Rauch/Gas/Nebel/Dampf/Aerosol vermeiden.', 38),
        ('ak_gefahrgut.sicherheit', 'P262', 'Nicht in die Augen, auf die Haut oder auf die Kleidung gelangen lassen.', 39),
        ('ak_gefahrgut.sicherheit', 'P263', 'Berührung während Schwangerschaft und Stillzeit vermeiden.', 40),
        ('ak_gefahrgut.sicherheit', 'P264', 'Nach Gebrauch ... gründlich waschen.', 41),
        ('ak_gefahrgut.sicherheit', 'P270', 'Bei Gebrauch nicht essen, trinken oder rauchen.', 43),
        ('ak_gefahrgut.sicherheit', 'P271', 'Nur im Freien oder in gut belüfteten Räumen verwenden.', 44),
        ('ak_gefahrgut.sicherheit', 'P272', 'Kontaminierte Arbeitskleidung nicht außerhalb des Arbeitsplatzes tragen.', 45),
        ('ak_gefahrgut.sicherheit', 'P273', 'Freisetzung in die Umwelt vermeiden.', 46),
        ('ak_gefahrgut.sicherheit', 'P280', 'Schutzhandschuhe/Schutzkleidung/Augenschutz/Gesichtsschutz/Gehörschutz/... tragen.'::varchar(100), 53),
        ('ak_gefahrgut.sicherheit', 'P282', 'Schutzhandschuhe mit Kälteisolierung/Gesichtsschild/Augenschutz tragen.', 54),
        ('ak_gefahrgut.sicherheit', 'P283', 'Schwer entflammbare oder flammhemmende Kleidung tragen.', 55),
        ('ak_gefahrgut.sicherheit', 'P284', '[Bei unzureichender Belüftung] Atemschutz tragen.', 56),
        ('ak_gefahrgut.sicherheit', 'P301', 'BEI VERSCHLUCKEN:', 59),
        ('ak_gefahrgut.sicherheit', 'P302', 'BEI BERÜHRUNG MIT DER HAUT:', 67),
        ('ak_gefahrgut.sicherheit', 'P303', 'BEI BERÜHRUNG MIT DER HAUT (oder dem Haar):', 74),
        ('ak_gefahrgut.sicherheit', 'P304', 'BEI EINATMEN:', 78),
        ('ak_gefahrgut.sicherheit', 'P305', 'BEI KONTAKT MIT DEN AUGEN:', 80),
        ('ak_gefahrgut.sicherheit', 'P306', 'BEI KONTAKT MIT DER KLEIDUNG:', 82),
        ('ak_gefahrgut.sicherheit', 'P308', 'BEI Exposition oder falls betroffen:', 84),
        ('ak_gefahrgut.sicherheit', 'P310', 'Sofort GIFTINFORMATIONSZENTRUM/Arzt/... anrufen.', 89),
        ('ak_gefahrgut.sicherheit', 'P311', 'GIFTINFORMATIONSZENTRUM/Arzt/... anrufen.', 92),
        ('ak_gefahrgut.sicherheit', 'P312', 'Bei Unwohlsein GIFTINFORMATIONSZENTRUM/Arzt/... anrufen', 95),
        ('ak_gefahrgut.sicherheit', 'P313', 'Ärztlichen Rat einholen/ärztliche Hilfe hinzuziehen.', 98),
        ('ak_gefahrgut.sicherheit', 'P314', 'Bei Unwohlsein ärztlichen Rat einholen/ärztliche Hilfe hinzuziehen.', 99),
        ('ak_gefahrgut.sicherheit', 'P315', 'Sofort ärztlichen Rat einholen/ärztliche Hilfe hinzuziehen.', 100),
        ('ak_gefahrgut.sicherheit', 'P320', 'Besondere Behandlung dringend erforderlich (siehe ... auf diesem Kennzeichnungsetikett).'::varchar(100), 101),
        ('ak_gefahrgut.sicherheit', 'P321', 'Besondere Behandlung (siehe ... auf diesem Kennzeichnungsetikett).', 102),
        ('ak_gefahrgut.sicherheit', 'P330', 'Mund ausspülen.', 103),
        ('ak_gefahrgut.sicherheit', 'P331', 'KEIN Erbrechen herbeiführen.', 104),
        ('ak_gefahrgut.sicherheit', 'P332', 'Bei Hautreizung:', 105),
        ('ak_gefahrgut.sicherheit', 'P333', 'Bei Hautreizung oder -ausschlag:', 107),
        ('ak_gefahrgut.sicherheit', 'P334', 'In kaltes Wasser tauchen [oder nassen Verband anlegen].', 109),
        ('ak_gefahrgut.sicherheit', 'P335', 'Lose Partikel von der Haut abbürsten.', 112),
        ('ak_gefahrgut.sicherheit', 'P336', 'Vereiste Bereiche mit lauwarmem Wasser auftauen. Betroffenen Bereich nicht reiben.'::varchar(100), 113),
        ('ak_gefahrgut.sicherheit', 'P337', 'Bei anhaltender Augenreizung:', 115),
        ('ak_gefahrgut.sicherheit', 'P338', 'Eventuell vorhandene Kontaktlinsen nach Möglichkeit entfernen. Weiter ausspülen.'::varchar(100), 117),
        ('ak_gefahrgut.sicherheit', 'P340', 'Die Person an die frische Luft bringen und für ungehinderte Atmung sorgen.', 118),
        ('ak_gefahrgut.sicherheit', 'P342', 'Bei Symptomen der Atemwege:', 119),
        ('ak_gefahrgut.sicherheit', 'P351', 'Einige Minuten lang behutsam mit Wasser ausspülen.', 123),
        ('ak_gefahrgut.sicherheit', 'P352', 'Mit viel Wasser/... waschen.', 124),
        ('ak_gefahrgut.sicherheit', 'P353', 'Haut mit Wasser abwaschen [oder duschen].', 126),
        ('ak_gefahrgut.sicherheit', 'P360', 'Kontaminierte Kleidung und Haut sofort mit viel Wasser abwaschen und danach Kleidung ausziehen.'::varchar(100), 129),
        ('ak_gefahrgut.sicherheit', 'P361', 'Alle kontaminierten Kleidungsstücke sofort ausziehen.', 130),
        ('ak_gefahrgut.sicherheit', 'P362', 'Kontaminierte Kleidung ausziehen.', 132),
        ('ak_gefahrgut.sicherheit', 'P363', 'Kontaminierte Kleidung vor erneutem Tragen waschen.', 134),
        ('ak_gefahrgut.sicherheit', 'P364', 'Und vor erneutem Tragen waschen.', 135),
        ('ak_gefahrgut.sicherheit', 'P370', 'Bei Brand:', 136),
        ('ak_gefahrgut.sicherheit', 'P371', 'Bei Großbrand und großen Mengen:', 151),
        ('ak_gefahrgut.sicherheit', 'P372', 'Explosionsgefahr.', 153),
        ('ak_gefahrgut.sicherheit', 'P373', 'KEINE Brandbekämpfung, wenn das Feuer explosive Stoffe/Gemische/Erzeugnisse erreicht.'::varchar(100), 154),
        ('ak_gefahrgut.sicherheit', 'P375', 'Wegen Explosionsgefahr Brand aus der Entfernung bekämpfen.', 155),
        ('ak_gefahrgut.sicherheit', 'P376', 'Undichtigkeit beseitigen, wenn gefahrlos möglich.', 156),
        ('ak_gefahrgut.sicherheit', 'P377', 'Brand von ausströmendem Gas: Nicht löschen, bis Undichtigkeit gefahrlos beseitigt werden kann.'::varchar(100), 157),
        ('ak_gefahrgut.sicherheit', 'P378', '... zum Löschen verwenden.', 158),
        ('ak_gefahrgut.sicherheit', 'P380', 'Umgebung räumen.', 163),
        ('ak_gefahrgut.sicherheit', 'P381', 'Bei Undichtigkeit alle Zündquellen entfernen.', 164),
        ('ak_gefahrgut.sicherheit', 'P390', 'Verschüttete Mengen aufnehmen, um Materialschäden zu vermeiden.', 165),
        ('ak_gefahrgut.sicherheit', 'P391', 'Verschüttete Mengen aufnehmen.', 166),
        ('ak_gefahrgut.sicherheit', 'P401', 'Aufbewahren gemäß ...', 167),
        ('ak_gefahrgut.sicherheit', 'P402', 'An einem trockenen Ort aufbewahren.', 168),
        ('ak_gefahrgut.sicherheit', 'P403', 'An einem gut belüfteten Ort aufbewahren.', 170),
        ('ak_gefahrgut.sicherheit', 'P404', 'In einem geschlossenen Behälter aufbewahren.', 173),
        ('ak_gefahrgut.sicherheit', 'P405', 'Unter Verschluss aufbewahren.', 174),
        ('ak_gefahrgut.sicherheit', 'P406', 'In korrosionsbeständigem/... Behälter mit korrosionsbeständiger Innenauskleidung aufbewahren.'::varchar(100), 175),
        ('ak_gefahrgut.sicherheit', 'P407', 'Luftspalt zwischen Stapeln oder Paletten lassen.', 176),
        ('ak_gefahrgut.sicherheit', 'P410', 'Vor Sonnenbestrahlung schützen.', 177),
        ('ak_gefahrgut.sicherheit', 'P411', 'Bei Temperaturen nicht über ... °C/... °F aufbewahren.', 180),
        ('ak_gefahrgut.sicherheit', 'P412', 'Nicht Temperaturen über 50°C/122°F aussetzen.', 181),
        ('ak_gefahrgut.sicherheit', 'P413', 'Schüttgut in Mengen von mehr als ... kg/...lbs bei Temperaturen nicht über ...°C/...°F aufbewahren.'::varchar(100), 182),
        ('ak_gefahrgut.sicherheit', 'P420', 'Getrennt aufbewahren.', 183),
        ('ak_gefahrgut.sicherheit', 'P501', 'Inhalt/Behälter ... zuführen.', 184),
        ('ak_gefahrgut.sicherheit', 'P502', 'Informationen zur Wiederverwendung oder Wiederverwertung beim Hersteller oder Lieferanten erfragen.'::varchar(100), 188),
        ('ak_gefahrgut.sicherheit', 'P503', 'Informationen zur Entsorgung/Wiederverwendung/Wiederverwertung beim Hersteller/Lieferanten erfragen.'::varchar(100), 189);

        INSERT INTO recnoenums
         (rege_reg_pname, rege_code, rege_bez, rege_pos)
        VALUES
        ('ak_gefahrgut.merkmal', 'EH001', 'In trockenem Zustand explosiv', 1),
        ('ak_gefahrgut.merkmal', 'EH014', 'Reagiert heftig mit Wasser.', 2),
        ('ak_gefahrgut.merkmal', 'EH018', 'Kann bei Verwendung explosionsfähige/entzündbare Dampf/Luft-Gemische bilden.', 3),
        ('ak_gefahrgut.merkmal', 'EH019', 'Kann explosionsfähige Peroxide bilden', 4),
        ('ak_gefahrgut.merkmal', 'EH029', 'Entwickelt bei Berührung mit Wasser giftige Gase', 5),
        ('ak_gefahrgut.merkmal', 'EH031', 'Entwickelt bei Berührung mit Säure giftige Gase', 6),
        ('ak_gefahrgut.merkmal', 'EH032', 'Entwickelt bei Berührung mit Säure sehr giftige Gase', 7),
        ('ak_gefahrgut.merkmal', 'EH044', 'Explosionsgefahr bei Erhitzen unter Einschluss', 8),
        ('ak_gefahrgut.merkmal', 'EH066', 'Wiederholter Kontakt kann zu spröder oder rissiger Haut führen', 9),
        ('ak_gefahrgut.merkmal', 'EH070', 'Giftig bei Berührung mit den Augen.', 10),
        ('ak_gefahrgut.merkmal', 'EH071', 'Wirkt ätzend auf die Atemwege.', 11),
        ('ak_gefahrgut.merkmal', 'EH201', 'Enthält Blei. Nicht für den Anstrich von Gegenständen verwenden, die von Kindern gekaut oder gelutsc'::varchar(100), 12),
        ('ak_gefahrgut.merkmal', 'EH202', 'Cyanacrylat. Gefahr. Klebt innerhalb von Sekunden Haut und Augenlider zusammen. Darf nicht in die Hä'::varchar(100), 13),
        ('ak_gefahrgut.merkmal', 'EH203', 'Enthält Chrom (VI). Kann allergische Reaktionen hervorrufen.', 14),
        ('ak_gefahrgut.merkmal', 'EH204', 'Enthält Isocyanate. Kann allergische Reaktionen hervorrufen.', 15),
        ('ak_gefahrgut.merkmal', 'EH205', 'Enthält epoxidhaltige Verbindungen. Kann allergische Reaktionen hervorrufen.', 16),
        ('ak_gefahrgut.merkmal', 'EH206', 'Achtung! Nicht zusammen mit anderen Produkten verwenden, da gefährliche Gase (Chlor) freigesetzt wer'::varchar(100), 17),
        ('ak_gefahrgut.merkmal', 'EH207', 'Achtung! Enthält Cadmium. Bei der Verwendung entstehen gefährliche Dämpfe. Hinweise des Herstellers '::varchar(100), 18),
        ('ak_gefahrgut.merkmal', 'EH208', 'Enthält .... Kann allergische Reaktionen hervorrufen.', 19),
        ('ak_gefahrgut.merkmal', 'EH209', 'Kann bei Verwendung leicht entzündbar werden.', 20),
        ('ak_gefahrgut.merkmal', 'EH210', 'Sicherheitsdatenblatt auf Anfrage erhältlich.', 21),
        ('ak_gefahrgut.merkmal', 'EH401', 'Zur Vermeidung von Risiken für Mensch und Umwelt die Gebrauchsanleitung einhalten.', 22);

        INSERT INTO recnoenums
         (rege_reg_pname, rege_code, rege_bez, rege_pos)
        VALUES
         ('ak_gefahrgut.wassergefaehrdungsklasse', 'nwg', 'nicht wassergefährdend', 1),
         ('ak_gefahrgut.wassergefaehrdungsklasse', 'awg', 'allgemein wassergefährdend', 2),
         ('ak_gefahrgut.wassergefaehrdungsklasse', 'WGK 1', 'schwach wassergefährdend', 3),
         ('ak_gefahrgut.wassergefaehrdungsklasse', 'WGK 2', 'deutlich wassergefährdend', 4),
         ('ak_gefahrgut.wassergefaehrdungsklasse', 'WGK 3', 'stark wassergefährdend', 5);

        INSERT INTO recnoenums
            (rege_reg_pname, rege_code, rege_bez, rege_pos)
        VALUES
            ('ak_gefahrgut.gefahrstofflagerklassen', '1', 'LGK 1', 1),
            ('ak_gefahrgut.gefahrstofflagerklassen', '2A', 'LGK 2A', 2),
            ('ak_gefahrgut.gefahrstofflagerklassen', '2B', 'LGK 2B', 3),
            ('ak_gefahrgut.gefahrstofflagerklassen', '3', 'LGK 3', 4),
            ('ak_gefahrgut.gefahrstofflagerklassen', '4.1A', 'LGK 4.1A', 5),
            ('ak_gefahrgut.gefahrstofflagerklassen', '4.1B', 'LGK 4.1B', 6),
            ('ak_gefahrgut.gefahrstofflagerklassen', '4.2', 'LGK 4.2', 7),
            ('ak_gefahrgut.gefahrstofflagerklassen', '4.3', 'LGK 4.3', 8),
            ('ak_gefahrgut.gefahrstofflagerklassen', '5.1A', 'LGK 5.1A', 9),
            ('ak_gefahrgut.gefahrstofflagerklassen', '5.1B', 'LGK 5.1B', 10),
            ('ak_gefahrgut.gefahrstofflagerklassen', '5.1C', 'LGK 5.1C', 11),
            ('ak_gefahrgut.gefahrstofflagerklassen', '5.2', 'LGK 5.2', 12),
            ('ak_gefahrgut.gefahrstofflagerklassen', '6.1A', 'LGK 6.1A', 13),
            ('ak_gefahrgut.gefahrstofflagerklassen', '6.1B', 'LGK 6.1B', 14),
            ('ak_gefahrgut.gefahrstofflagerklassen', '6.1C', 'LGK 6.1C', 15),
            ('ak_gefahrgut.gefahrstofflagerklassen', '6.1D', 'LGK 6.1D', 16),
            ('ak_gefahrgut.gefahrstofflagerklassen', '6.2', 'LGK 6.2', 17),
            ('ak_gefahrgut.gefahrstofflagerklassen', '7', 'LGK 7', 18),
            ('ak_gefahrgut.gefahrstofflagerklassen', '8A', 'LGK 8A', 19),
            ('ak_gefahrgut.gefahrstofflagerklassen', '8B', 'LGK 8B', 20),
            ('ak_gefahrgut.gefahrstofflagerklassen', '10*', 'LGK 10*', 21),
            ('ak_gefahrgut.gefahrstofflagerklassen', '11*', 'LGK 11*', 22),
            ('ak_gefahrgut.gefahrstofflagerklassen', '12*', 'LGK 12*', 23),
            ('ak_gefahrgut.gefahrstofflagerklassen', '13*', 'LGK 13*', 24),
            ('ak_gefahrgut.gefahrstofflagerklassen', '10-13', 'LGK 10-13', 25);

        -- Suchoptionen für Lagerorte beim ABK-bezogenen Lagerabgang
        INSERT INTO recnoenums
         (rege_reg_pname, rege_code, rege_bez, rege_pos)
        VALUES

        ---- Standard-FIFO-Suche, welche nur Grundartikel berücksichtigt.
        ---- Es werden nur soviele Lagerorte ausgewählt, wie zur Bedarfsdeckung notwendig sind.
        ---- Diese Option entspricht "keine Suchoption ausgewählt" und deswegen nicht extra aktiviert.
        ('lagerabgang.abk.alternativartikel.suche', 'ST', 'Ohne Alternativen, nur exakte Materialliste', 1),

        ---- Im Prinzip ähnlich der Standard-FIFO-Suche, nur werden Alternativartikel dann herangezogen,
        ---- wenn der Bestand des Grundartikels für die Bedarfsdeckung nicht ausreicht.
        ('lagerabgang.abk.alternativartikel.suche', 'GA', 'Grund- vor Alternativartikel',      2),

        ---- Zur Bedarfsdeckung sollen möglichst wenig verschiedene Artikel verwendet werden.
        ---- Mangels Kundenrelevanz derzeit nicht aktiv.
        --('lagerabgang.abk.alternativartikel.suche', 'SR', 'Möglichst sortenrein',              3),

        ---- Zur Bedarfsdeckung sollen möglichst wenig verschiedene Chargen verwendet werden.
        ('lagerabgang.abk.alternativartikel.suche', 'CH', 'Möglichst wenige Chargen',          4),

        ---- Zur Bedarfsdeckung sollen möglichst viele Lagerorte herangezogen werden, die dadurch geleert werden
        ---- und eine Lagerverdichtung stattfindet.
        ---- Mangels Kundenrelevanz derzeit nicht aktiv.
        --('lagerabgang.abk.alternativartikel.suche', 'LP', 'Lagerplätze leeren',                5)

        ---- Es werden alle zur Bedarfsdeckung prinzipiell infrage kommenden Lagerorte angezeigt,
        ---- ohne Rücksicht auf den eigentlichen Bedarf.
        ('lagerabgang.abk.alternativartikel.suche', 'AL', 'Alle Artikel',                      6),

        ---- Es werden alle zur Bedarfsdeckung prinzipiell infrage kommenden Lagerorte der Alternativartikel angezeigt,
        ---- ohne Rücksicht auf den eigentlichen Bedarf.
        ('lagerabgang.abk.alternativartikel.suche', 'AM', 'Nur Alternativartikel',             7),

        ---- Es werden wie in alten Versionen nur ein Lagerort pro Bedarfsposition.
        ('lagerabgang.abk.alternativartikel.suche', 'EI', 'Nur ein Lagerort pro Artikel',      8);


        -- Hinttexte für die Suchoptionen für Lagerorte beim ABK-bezogenen Lagerabgang
        -- Bei den Bezeichnern handelt es sich um die xtt-Nummern der eigentlichen Hints
        INSERT INTO recnoenums
         (rege_reg_pname, rege_code, rege_bez, rege_pos)
        VALUES
        ('lagab.abk.alternativartikel.suche.hilfe', 'ST', '28763', 1),
        ('lagab.abk.alternativartikel.suche.hilfe', 'GA', '28762', 2),
        ('lagab.abk.alternativartikel.suche.hilfe', 'SR', '28761', 3),
        ('lagab.abk.alternativartikel.suche.hilfe', 'CH', '28760', 4),
        ('lagab.abk.alternativartikel.suche.hilfe', 'LP', '28759', 5),
        ('lagab.abk.alternativartikel.suche.hilfe', 'AL', '28758', 6),
        ('lagab.abk.alternativartikel.suche.hilfe', 'AM', '28757', 7),
        ('lagab.abk.alternativartikel.suche.hilfe', 'EI', '28708', 8);


    -- CoC Vorgaben

        INSERT INTO recnogroup
         (reg_tablename, reg_gruppe, reg_bez, reg_bez_textno, reg_pname, reg_paramtype)
        VALUES
        ('art', 'CoC.ART', 'Art der Prüfbescheinigung', 26096,'CoC.ART.PruefbescheinigungsArt', 'ptVARCHAR'),
        ('art', 'CoC.ART', 'Bemerkungstext', 26099,'CoC.ART.Bemerkungstext', 'ptVARCHAR'),
        ('art', 'CoC.ART', 'Erstmusterprüfbericht / First Article Inspection Report', 26103,'CoC.ART.Erstmusterpruefbericht', 'ptVARCHAR'),
        ('art', 'CoC.ART', 'Keine / None', 25214,'CoC.ART.Keine', 'ptVARCHAR'),
        ('art', 'CoC.ART', 'Materialzeugnis / Material Attest', 26097,'CoC.ART.MatZg', 'ptVARCHAR'),
        ('art', 'CoC.ART', 'Messprotokoll / Measuring Print', 26100,'CoC.ART.Messprotokoll', 'ptVARCHAR'),
        ('art', 'CoC.ART', 'Sonstiges / Other', 26098,'CoC.ART.Sonstiges', 'ptVARCHAR'),
        ('art', 'CoC.ART', 'Zeugnis Oberflächenbehandlung / Attest Surfacetreatment', 26102,'CoC.ART.Zeugnis.Oberflaechenbehandlung', 'ptVARCHAR'),
        ('art', 'CoC.ART', 'Zeugnis Wärmebehandlung / Attest Heattreatment', 26101,'CoC.ART.Zeugnis.Waermebehandlung', 'ptVARCHAR');

        INSERT INTO recnogroup
         (reg_tablename, reg_gruppe, reg_bez, reg_bez_textno, reg_pname, reg_paramtype)
        VALUES
        ('cocpos', 'CoC', 'Art der Prüfbescheinigung', 26096,'CoC.PruefbescheinigungsArt', 'ptVARCHAR'),
        ('cocpos', 'CoC', 'Bemerkungstext', 26099,'CoC.Bemerkungstext', 'ptVARCHAR'),
        ('cocpos', 'CoC', 'Erstmusterprüfbericht / First Article Inspection Report', 26103,'CoC.Erstmusterpruefbericht', 'ptVARCHAR'),
        ('cocpos', 'CoC', 'Keine / None', 25214,'CoC.Keine', 'ptVARCHAR'),
        ('cocpos', 'CoC', 'Materialzeugnis / Material Attest', 26097,'CoC.MatZg', 'ptVARCHAR'),
        ('cocpos', 'CoC', 'Messprotokoll / Measuring Print', 26100,'CoC.Messprotokoll', 'ptVARCHAR'),
        ('cocpos', 'CoC', 'Sonstiges / Other', 26098,'CoC.Sonstiges', 'ptVARCHAR'),
        ('cocpos', 'CoC', 'Zeugnis Oberflächenbehandlung / Attest Surfacetreatment', 26102,'CoC.Zeugnis.Oberflaechenbehandlung', 'ptVARCHAR'),
        ('cocpos', 'CoC', 'Zeugnis Wärmebehandlung / Attest Heattreatment', 26101,'CoC.Zeugnis.Waermebehandlung', 'ptVARCHAR');

    -- Personal und Schulungsmanagement
        -- Schulungsplanung - Status
            INSERT INTO recnogroup
            (reg_bez, reg_gruppe, reg_default, reg_paramtype, reg_tablename, reg_pname, reg_pos, reg_exclusive, reg_autoinsert)
            VALUES
            ('Schulungsplanung-Status', 'Schulungsplanung', 'P', 'ptENUM', 'skillplan', 'skillplan.status.plan', 1, true, true);

            INSERT INTO recnoenums
            (rege_reg_pname, rege_code, rege_bez            , rege_pos)
            VALUES
            ('skillplan.status.plan', 'P', 'Planung / Provisorisch', 1),
            ('skillplan.status.plan', 'F', 'Fix / Fest eingeplant'       , 2);

        -- Schulungsplanung-Teilnehmer - Status
            INSERT INTO recnogroup
            (reg_bez, reg_gruppe, reg_default, reg_paramtype, reg_tablename, reg_pname, reg_pos, reg_exclusive, reg_autoinsert)
            VALUES
            ('Teilnehmer-Status', 'Schulungsplanung', 'P', 'ptENUM', 'llv_members', 'llv_members.skillplan.status', 1, true, true);

            INSERT INTO recnoenums
            (rege_reg_pname, rege_code, rege_bez, rege_pos)
            VALUES
            ('llv_members.skillplan.status', 'P', 'Planung', 1),
            ('llv_members.skillplan.status', 'T', 'Teilgenommen', 2);


        --Intervallsteuerung zum Quali-Artikel
            INSERT INTO recnogroup (reg_tablename, reg_gruppe, reg_gruppe_textno, reg_bez, reg_bez_textno, reg_paramtype, reg_pname, reg_autoinsert) VALUES
            ('art', 'Qualifikationen', 15387, 'Prüfintervall', 4455, 'ptINTEGER', 'skill.intervall', false);
    --

    -- ZDok Barcode usw.
        INSERT INTO recnogroup
        (reg_bez, reg_gruppe, reg_paramtype, reg_tablename, reg_pname, reg_pos)
        VALUES
        ('Barcode Artikel-Nr.', 'Zentraldokument', 'ptTRISTATEBOOLEAN', 'adk', 'Zentraldokument.BC.ArtNr', 1),
        ('Barcode Beleg-Nr.', 'Zentraldokument', 'ptTRISTATEBOOLEAN', 'adk', 'Zentraldokument.BC.BelegNr', 2),
        ('Barcode Referenz Position', 'Zentraldokument', 'ptTRISTATEBOOLEAN', 'adk', 'Zentraldokument.BC.PosRef', 3),
        ('Barcode Artikel-Nr. Kunde', 'Zentraldokument', 'ptTRISTATEBOOLEAN', 'adk', 'Zentraldokument.BC.ArtRef', 4),
        ('Barcode Menge Position', 'Zentraldokument', 'ptTRISTATEBOOLEAN', 'adk', 'Zentraldokument.BC.PosMenge', 5),
        ('Barcode Beleg-Nr. Kunde', 'Zentraldokument', 'ptTRISTATEBOOLEAN', 'adk', 'Zentraldokument.BC.BelegKunde', 6),
        ('Barcode Typ', 'Zentraldokument', 'ptENUM', 'adk', 'Zentraldokument.BC.Typ', 7)
        ;
        -- Zugehörige Barcodetypen
        INSERT INTO recnoenums(rege_reg_pname,           rege_pos, rege_code, rege_bez)
        VALUES                ('Zentraldokument.BC.Typ', 10,       '3',       'bcCode39'),
                              ('Zentraldokument.BC.Typ', 20,       '4',       'bcCode39Extended'),
                              ('Zentraldokument.BC.Typ', 30,       '5',       'bcCode128'),
                              ('Zentraldokument.BC.Typ', 40,       '6',       'bcCode128A'),
                              ('Zentraldokument.BC.Typ', 40,       '7',       'bcCode128B'),
                              ('Zentraldokument.BC.Typ', 40,       '8',       'bcCode128C'),
                              ('Zentraldokument.BC.Typ', 40,       '21',      'bcCodeEAN128'),
                              ('Zentraldokument.BC.Typ', 40,       '22',      'bcCodeEAN128A')
        ;
    --


    /* #17291 Versandoptmierung Spektra
    INSERT INTO recnogroup (reg_tablename, reg_paramtype, reg_default,   reg_field_name, reg_field_value, reg_pname             , reg_autoinsert, reg_gruppe, reg_exclusive, reg_bez )
                    VALUES ('adk'        , 'ptENUM'     , NULL       ,   NULL          , NULL           , 'versand.spediteur'   , false         , 'VERSAND' , true        , 'Spediteur' ),
                           ('auftg'      , 'ptENUM'     , NULL       ,   NULL          , NULL           , 'versand.spediteur'   , false         , 'VERSAND' , true        , 'Spediteur' ),
                           ('adk'        , 'ptVARCHAR'  , NULL       ,   NULL          , NULL           , 'versand.konto.1'     , false         , 'VERSAND' , NULL        , 'Konto-Nr. DHL Express' ),
                           ('auftg'      , 'ptVARCHAR'  , NULL       ,   NULL          , NULL           , 'versand.konto.1'     , false         , 'VERSAND' , NULL        , 'Konto-Nr. DHL Express' ),
                           ('adk'        , 'ptVARCHAR'  , NULL       ,   NULL          , NULL           , 'versand.konto.2'     , false         , 'VERSAND' , NULL        , 'Konto-Nr. DHL Paket' ),
                           ('auftg'      , 'ptVARCHAR'  , NULL       ,   NULL          , NULL           , 'versand.konto.2'     , false         , 'VERSAND' , NULL        , 'Konto-Nr. DHL Paket' ),
                           ('adk'        , 'ptVARCHAR'  , NULL       ,   NULL          , NULL           , 'versand.konto.3'     , false         , 'VERSAND' , NULL        , 'Konto-Nr. UPS' ),
                           ('auftg'      , 'ptVARCHAR'  , NULL       ,   NULL          , NULL           , 'versand.konto.3'     , false         , 'VERSAND' , NULL        , 'Konto-Nr. UPS' ),
                           ('auftg'      , 'ptVARCHAR'  , NULL       ,   NULL          , NULL           , 'versand.tracking.id' , false         , 'VERSAND' , NULL        , 'Tracking-ID' )
    ;

    INSERT INTO recnoenums (rege_reg_pname      , rege_code , rege_bez     )
                   VALUES  ('versand.spediteur' , '1'       , 'DHL Express'),
                           ('versand.spediteur' , '2'       , 'DHL Paket'  ),
                           ('versand.spediteur' , '3'       , 'UPS'        )
    ;
    */


    -- Vorgaben für die Terminverschiebung
    INSERT INTO public.recnogroup(reg_tablename, reg_bez, reg_gruppe, reg_pos, reg_pname, reg_paramtype, reg_visible, reg_autoinsert) VALUES
    ('terminverschiebung','Einkauf','Terminverschiebung Vorgabe',1,'terminverschiebung.kategorie.einkauf','ptENUM',TRUE,FALSE);
    INSERT INTO public.recnogroup(reg_tablename, reg_bez, reg_gruppe, reg_pos, reg_pname, reg_paramtype, reg_visible, reg_autoinsert) VALUES
    ('terminverschiebung','Verkauf','Terminverschiebung Vorgabe',1,'terminverschiebung.kategorie.verkauf','ptENUM',TRUE,FALSE);
    INSERT INTO public.recnogroup(reg_tablename, reg_bez, reg_gruppe, reg_pos, reg_pname, reg_paramtype, reg_visible, reg_autoinsert) VALUES
    ('terminverschiebung','Auswirkung','Terminverschiebung Vorgabe',1,'terminverschiebung.auswirkung','ptENUM',TRUE,FALSE);
    INSERT INTO public.recnogroup(reg_tablename, reg_bez, reg_gruppe, reg_pos, reg_pname, reg_paramtype, reg_visible, reg_autoinsert) VALUES
    ('terminverschiebung','Ursache','Terminverschiebung Vorgabe',1,'terminverschiebung.ursache','ptENUM',TRUE,FALSE);
    INSERT INTO public.recnogroup(reg_tablename, reg_bez, reg_gruppe, reg_pos, reg_pname, reg_paramtype, reg_visible, reg_autoinsert) VALUES
    ('terminverschiebung','Verursacher','Terminverschiebung Vorgabe',1,'terminverschiebung.verursacher','ptENUM',TRUE,FALSE);
    INSERT INTO public.recnogroup(reg_tablename, reg_bez, reg_gruppe, reg_pos, reg_pname, reg_paramtype, reg_visible, reg_autoinsert) VALUES
    ('terminverschiebung','Entscheider','Terminverschiebung Vorgabe',1,'terminverschiebung.entscheider','ptENUM',TRUE,FALSE);

    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.kategorie.einkauf','BSTL','Lagereingang der Bestellung',1);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.kategorie.einkauf','BSTZ','Bestellzeitpunkt',2);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.kategorie.verkauf','KA','Kundenauftrag',1);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.kategorie.verkauf','PAS','Starttermin eines Produktionsauftrags',2);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.kategorie.verkauf','PAE','Endtermin eines Produktionsauftrags',3);

    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.auswirkung','STO','Stornierung',1);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.auswirkung','AUT','Aufteilung',2);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.auswirkung','UNL','Unterlieferung',3);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.auswirkung','FIA','finanzieller Ausgleich',4);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.auswirkung','KTV','Kundentermin verfehlt',5);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.auswirkung','PUP','Produktionsumplanung',6);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.auswirkung','KWA','keine weiteren Auswirkungen',7);

    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.ursache','GE','Geschäftsentscheidung',1);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.ursache','TD','technischer Defekt',2);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.ursache','PE','personeller Engpass',3);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.ursache','HG','höhere Gewalt',4);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.ursache','ATV','andere Terminverschiebung',5);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.ursache','WNG','Ware nicht geliefert',6);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.ursache','MNV','Material nicht verfügbar',7);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.ursache','MQM','Material hat Qualitätsmängel',8);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.ursache','ZF','Zeichnungsfehler',9);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.ursache','FZI','falscher Zeichnngsindex',10);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.ursache','FTK','fehlende Transportkapazität',11);

    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.verursacher','LIE','Lieferant',1);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.verursacher','FIR','Firma',2);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.verursacher','NV','Neuvereinbarung',3);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.verursacher','EXQ','externe Quelle',4);

    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.entscheider','GF','GeschäftsFührung',1);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.entscheider','EK','Einkauf',2);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('terminverschiebung.entscheider','PL','Produktionsleitung',3);

    -- Vorgaben zu Notizenkategorien
    INSERT INTO public.recnogroup(reg_tablename, reg_bez, reg_gruppe, reg_pos, reg_pname, reg_paramtype, reg_visible, reg_autoinsert)
    VALUES ('recnocomments', 'alle Kunden', 'Notizenkategorie', 1, 'Notizenkategorie alle', 'ptENUM', TRUE, FALSE);
    INSERT INTO public.recnogroup(reg_tablename, reg_bez, reg_gruppe, reg_pos, reg_pname, reg_paramtype, reg_visible, reg_autoinsert)
    VALUES ('recnocomments', 'DEVELOP', 'Notizenkategorie', 1, 'Notizenkategorie DEVELOP', 'ptENUM', TRUE, FALSE);
    INSERT INTO public.recnogroup(reg_tablename, reg_bez, reg_gruppe, reg_pos, reg_pname, reg_paramtype, reg_visible, reg_autoinsert)
    VALUES ('recnocomments', 'LOLL', 'Notizenkategorie', 1, 'Notizenkategorie LOLL', 'ptENUM', TRUE, FALSE);

    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie alle','VER','Vertrieb',1);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie alle','AUS','Auswärts',2);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie alle','PLA','Plantafel',3);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie alle','TV','Terminverschiebung',4);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie DEVELOP','VER','Vertrieb',1);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie DEVELOP','AUS','Auswärts',2);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie DEVELOP','PLA','Plantafel',3);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie DEVELOP','TV','Terminverschiebung',4);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie DEVELOP','UMS','Umsatzplanung',5);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie DEVELOP','POW','Powerliste',6);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie DEVELOP','COC','CoC',7);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie DEVELOP','VV','Verbesserungsvorschlag',8);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie LOLL','VER','Vertrieb',1);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie LOLL','AUS','Auswärts',2);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie LOLL','PLA','Plantafel',3);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie LOLL','TV','Terminverschiebung',4);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie LOLL','UMS','Umsatzplanung',5);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie LOLL','POW','Powerliste',6);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie LOLL','COC','CoC',7);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie LOLL','VV','Verbesserungsvorschlag',8);

    --Vorgaben zu Notizenkategorien(Freda/Mobile)
    INSERT INTO public.recnogroup(reg_tablename, reg_bez, reg_gruppe, reg_pos, reg_pname, reg_paramtype, reg_default, reg_vorgabenliste, reg_visible, reg_autoinsert, reg_exclusive)
    VALUES ('recnocomments', 'Vorgaben Notizen Mobile', 'Notizenkategorie', 10, 'Notizenkategorie.Mobile', 'ptENUM', 'DOK', TRUE, TRUE, FALSE, TRUE);

    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie.Mobile', 'DOK', 'Dokumentation', 10);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie.Mobile', 'INF', 'Information', 20);
    INSERT INTO public.recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
    VALUES ('Notizenkategorie.Mobile', 'PRO', 'Problem', 30);

    -- Lagerabgänge auf gleiche Auftragsposition zusammenfassen
    SELECT TSystem.Settings__Set('MergeLagAbg', True);

    -- datarowstate #5617
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('tplan', 'sGueltig', 1, 26061, NULL);
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('art', 'sEP', 1, 4080, 'ak_fertigung');
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('art', 'sRMat', 2, 672, 'ac_i=3');
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('art', 'sStkl', 5, 738, 'EXISTS(SELECT true FROM stv WHERE st_zn=ak_nr)');
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('art', 'sElemStkl', 6, 4215, 'EXISTS(SELECT true FROM stv WHERE st_n=ak_nr)');
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('art', 'sDL', 7, 2779, 'ac_i=50');
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_filtersql, drs_textnr, drs_defregister)
         VALUES ('art', 'aPruef', 8, 'EXISTS( SELECT 1 FROM artcod WHERE ak_ac = ac_n AND ac_i = 25 )', 1039, false);

    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('adk', 'sDebitor', 1, 2916, 'a1_knr IS NOT NULL');
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('adk', 'sKreditor', 2, 4309, 'a2_knr IS NOT NULL');

    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('anl', 'sOffen', 1, 1295, 'NOT an_done');
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('abk', 'sOffen', 1, 1295, 'NOT ab_done');

    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql, drs_defRegister) VALUES ('auftg', 'sOffen', 1, 1295, 'NOT ag_done', true);
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql, drs_defRegister) VALUES ('auftg', 'sLastYear', 2, 21540, 'auftg.insert_date > current_date-365', true);
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('auftg', 'sPos1', 10, 21533, 'ag_pos=1');

    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('auftgi', 'sOffen', 1, 1295, 'NOT ag_done');


    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql, drs_defRegister) VALUES ('ldsdok', 'sOffen', 1, 1295, 'NOT ld_done', true);
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql, drs_defRegister) VALUES ('ldsdok', 'sLastYear', 2, 21540, 'ldsdok.insert_date > current_date-365', true);
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('ldsdok', 'sPos1', 10, 21533, 'ld_pos=1');

    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('anfrage', 'sLastYear', 1, 21540, 'anfrage.insert_date > current_date-365');
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql, drs_defRegister) VALUES ('anfrage', 'sOffen', 2, 1295, 'NOT anf_done', true);

    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql, drs_defRegister) VALUES ('rechnungv_belegext', 'sLastYear', 1, 21540, 'd_insert_date > current_date-365', true);
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('rechnungv_belegext', 'sOffen', 2, 16434, 'NOT d_zahlung_done'); -- Offen


    INSERT INTO datarowstate (drs_type, drs_code, drs_textnr, drs_filtersql) VALUES ('ab2', 'sOffen', 1295, 'NOT a2_ende');

    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('eingrechdokument', 'sOffen', 1, 3822, 'NOT beld_definitiv'); -- Offen
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('eingrechdokument', 'sUngeprft', 1, 29121, 'NOT beld_geprueft'); -- Nicht geprüft
    INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql) VALUES ('eingrechdokument', 'sPos1', 1, 29122, 'belp_pos = 1'); -- Nur Position 1

    INSERT INTO datarowstate (   drs_type, drs_code, drs_sort, drs_textnr,        drs_filtersql )
    VALUES                   ( 'eingrech', 'sOffen',        1,       3822, 'NOT beld_definitiv' );

    INSERT INTO datarowstate (   drs_type,    drs_code, drs_sort, drs_textnr,        drs_filtersql )
    VALUES                   ( 'eingrech', 'sUngeprft',        1,      29121,  'NOT beld_geprueft' );

    INSERT INTO datarowstate (   drs_type,  drs_code, drs_sort, drs_textnr,  drs_filtersql )
    VALUES                   ( 'eingrech',   'sPos1',        1,      29122, 'belp_pos = 1' );

    INSERT INTO datarowstate ( drs_type,     drs_code, drs_sort, drs_textnr,                                      drs_filtersql, drs_defregister )
    VALUES                   ( 'wendat', 'sUngueltig',        1,      35067, 'COALESCE(w_lfsnr,'''') NOT LIKE ''RETOURE-ABK%''',            true ); -- Nur Lagerzugänge die nicht aus Materialrückführungen stammen

--Einstiegsstandardfilter für Event-Log (Dashboard für Administratoren)
INSERT INTO datarowstate (drs_type, drs_sort, drs_code, drs_filtersql, drs_textnr, drs_defregister)
VALUES --siehe tlog.dblog_logtype
  ('AdminDash_dframe_1_lcFrame_1', 10, 'pltSQL',     'dbl_type = ''pltSQL''',         26698, false),
  ('AdminDash_dframe_1_lcFrame_1', 20, 'pltDebuggi', 'dbl_type = ''pltDebugging''',   26699, true),
  ('AdminDash_dframe_1_lcFrame_1', 30, 'pltProfili', 'dbl_type = ''pltProfiling''',   26700, false),
  ('AdminDash_dframe_1_lcFrame_1', 40, 'pltStatist', 'dbl_type = ''pltStatistics''',  26701, false),
  ('AdminDash_dframe_1_lcFrame_1', 50, 'pltHttpReq', 'dbl_type = ''pltHttpRequest''', 26702, false),
  ('AdminDash_dframe_1_lcFrame_1', 60, 'pltUserInf', 'dbl_type = ''pltUserInfo''',    26703, false);

--- #22038
INSERT INTO datarowstate (drs_type, drs_code, drs_sort, drs_textnr, drs_filtersql   , drs_defRegister)
  VALUES                 ('qab'   , 's8D'   , 1       , 28718     , 'qgc_bez_xtt = 28718', true),
                         ('qab'   , 's3D'   , 2       , 28717     , 'qgc_bez_xtt = 28717', false),
                         ('qab'   , 's4D'   , 3       , 28716     , 'qgc_bez_xtt = 28716', false);
---
-- Lieferantenbewertung: Vorgaben nach IHK-Notenschlüssel
INSERT INTO lbwnote (lbn_note, lbn_bpunkte)
VALUES
  ('1', 92),
  ('2', 81),
  ('3', 67),
  ('4', 50),
  ('5', 30),
  ('6',  0)
;

-- Zahlungskonditionen
INSERT INTO addison_zahlb(azb_id, azb_bez, azb_skonto, azb_proz, azb_zlg, azb_adk_def)
VALUES (1, '30 Tage', 0, 0, 30, 'EV');


-- Steutxt s_inha = inha AND s_vari = vari
SELECT TSystem.Settings__Set('auftgsteucode', 3); -- Vorgabe Vorsteuer 19%
SELECT TSystem.Settings__Set('einksteucode', 9); -- Vorgabe USt 19%

-- Systemeinstellung: Standardvorgabe für Preisquelle und Reihenfolge.
SELECT TSystem.Settings__Set('EKPSources', 'EKP_LDSDOK, EKP_EPREIS_E_STAL, EKP_EPREIS, EKP_ANFANGEBOT, EKP_EINGRECH, EKP_ART_AK_HEST' ); -- EKP_LDSDOK=> Rahmen!

-- Systemeinstellung: Standardvorgabe für maximale Gültigkeitsdauer / Alter eines Preises damit er noch vorgeschlagen wird (in Jahren)
SELECT TSystem.Settings__Set('EKPMaxAlter', 5 );

-- Systemeinstellung: Assistenten
SELECT TSystem.Settings__Set('Assistent_TFormAssWawi_DayLimit', 90); -- 90 Tage Limit für Assistent Fertigung setzen
SELECT TSystem.Settings__Set('Assistent_TFormAssFert_DayLimit', 90); -- 90 Tage Limit für Assistent Warenwirtschaft setzen

-- Setting für die  Rundungsgenauigkeit der Raucherpausen erstellen mit 15min als Voreinstellung
SELECT TSystem.Settings__Set('bde_rpause_rundung_faktor', 15);
--
-- #12153 [Vertrieb-Angebotsauswertung] Anpassung Assistent Vertrieb: "A-Pos. Ohne Dokument"
SELECT TSystem.Settings__Set('Assistent_Vertrieb__AuftgAEohneBestaetigung__XTage__rot_markieren', 7);
--
-- #12154 [Vertrieb-Angebotsauswertung] Anpassung Assistent Vertrieb: "Offene Angebote"
SELECT TSystem.Settings__Set('Assistent_Vertrieb__Offene_Angebote__XTage__rot_markieren', 7);
--

-- #12036 Globale Pufferzeit für Material-Bedarfstermine bei Projekt-ABK
SELECT TSystem.Settings__Set('ABK.AuftgI.Projekt.Pufferzeit.global', 14);
--

--#14161 ausblenden der anteiligen Auftragszeit im Report Mitarbeiterauswertung einzeln
SELECT TSystem.Settings__Set('REPORTS_BDE_ANTEIL_AUFTRAGSZEIT_PRAESENSZEIT', false);

--------------------------------- ENPLAN / TECHPLAN VORGABEN ---------------------------------

-- Verschiedene Tabellen, aber alles hier angelegt damit zusammengehalten.

-- Standardmengeneinheiten für Strom / Leistung
    INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (97, 'h',   'Stunden') ON CONFLICT DO NOTHING;         -- Für En/TechPlan angelegt.
    INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (98, 'kw',  'Kilowatt') ON CONFLICT DO NOTHING;        -- Für En/TechPlan angelegt.
    INSERT INTO mgcode (me_cod, me_iso, me_bez) VALUES (99, 'kwh', 'Kilowattstunden') ON CONFLICT DO NOTHING; -- Für En/TechPlan angelegt.

-- Techplan / EnPlan
    -- Energiemedien ...
        INSERT INTO epMedium (med_id, med_bez, med_me) VALUES (1,'Strom',99) ON CONFLICT DO NOTHING;
        --
        INSERT INTO epKnotentyp(knt_id, knt_textno) VALUES(0,13702) ON CONFLICT DO NOTHING; -- Prod.Maschine (Techplan)
        INSERT INTO epKnotentyp(knt_id, knt_textno) VALUES(1,12340) ON CONFLICT DO NOTHING; -- Prod.Maschine
        INSERT INTO epKnotentyp(knt_id, knt_textno) VALUES(2,12341) ON CONFLICT DO NOTHING; -- Energielieferant (Abbildung Energiefluß von Außerhalb)
        INSERT INTO epKnotentyp(knt_id, knt_textno) VALUES(3,12345) ON CONFLICT DO NOTHING; -- Sonst.Energiewandler (Heizung, Klima, Wärmerückgewinnung Ofen etc ... )

    -- Parametertypen für Formeln
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (0,'PARAMETER',12406) ON CONFLICT DO NOTHING;      -- Modellkonstante               (z.Bsp: Max. Zuladung Ofen immer = 20t)
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (1,'PARAMETER',12407) ON CONFLICT DO NOTHING;  -- Arbeitsgangkonstante          (z.Bsp: ABG1= Temp 650°C, ABG2 = Temp 550°C)
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (2,'PARAMETER',12408) ON CONFLICT DO NOTHING;  -- Dynamisch (pro Rechenschritt) (z.Bsp: Hauptzeit aller ABG im Rechenschritt, einmal pro RS ausgewertet)
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (3,'PARAMETER',12409) ON CONFLICT DO NOTHING;  -- Dynamisch (pro Arbeitsgang)   (z.Bsp: Summiertes Gewicht über Pool-ABG)
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (4,'PARAMETER',12723) ON CONFLICT DO NOTHING;  -- Dynamisch (pro Berechnung)    (z.Bsp: Summiertes Gewicht über Pool-ABG)

    -- Ergebnistypen
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (200,'RESULT', 3017)  ON CONFLICT DO NOTHING;  -- verwerfen            --> Nichts zurückgegeben
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (201,'RESULT', 12810) ON CONFLICT DO NOTHING;  -- Verlaufswerte        --> Für jeden Rechenschritt einen Wert im Dataset ablegen
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (202,'RESULT', 12811) ON CONFLICT DO NOTHING;  -- Erster Wert          --> Aus den Werten aller Rechenschritte, den einen Wert aufheben
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (203,'RESULT', 12812) ON CONFLICT DO NOTHING;  -- Letzer Wert          --> Aus den Werten aller Rechenschritte, den einen Wert aufheben
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (204,'RESULT', 12813) ON CONFLICT DO NOTHING;  -- Summe der Einzelwerte    --> Aus den Werten aller Rechenschritte, den einen Wert bilden
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (205,'RESULT', 12814) ON CONFLICT DO NOTHING;  -- Minimum der Einzelwerte  --> Aus den Werten aller Rechenschritte, den einen Wert aufheben
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (206,'RESULT', 12815) ON CONFLICT DO NOTHING;  -- Maximum der Einzelwerte  --> Aus den Werten aller Rechenschritte, den einen Wert aufheben
        INSERT INTO epberechnungstyp (bert_id, bert_typ, bert_textno) VALUES (207,'RESULT', 12816) ON CONFLICT DO NOTHING;  -- Mittel der Einzelwerte   --> Aus den Werten aller Rechenschritte, den einen Wert bilden

    -- Betriebszustände für Fertigungsmaschinen
        INSERT INTO epBetriebszustand (bzu_id, bzu_bez, bzu_pos) VALUES ('S','Standby'  , 1) ON CONFLICT DO NOTHING;
        INSERT INTO epBetriebszustand (bzu_id, bzu_bez, bzu_pos) VALUES ('R','Rüstzeit' , 2) ON CONFLICT DO NOTHING;
        INSERT INTO epBetriebszustand (bzu_id, bzu_bez, bzu_pos) VALUES ('H','Hauptzeit', 3) ON CONFLICT DO NOTHING;
        INSERT INTO epBetriebszustand (bzu_id, bzu_bez, bzu_pos) VALUES ('N','Nebenzeit', 4) ON CONFLICT DO NOTHING;

    -- Default-Versorger für Strom
        INSERT INTO epenergielieferant (enl_id, enl_krz, enl_med_id, enl_me, enl_isdefault) VALUES ( 1, 'VERSORGER', 1, 99, TRUE) ON CONFLICT DO NOTHING;

    -- DELETE FROM recnogroup WHERE reg_gruppe ='TechPlan';
        INSERT INTO recnogroup (reg_tablename, reg_gruppe, reg_bez, reg_bez_textno, reg_pname, reg_paramtype, reg_default, reg_autoinsert, reg_m_iso ) VALUES
            ('ksv', 'TechPlan', 'Anschlussleistung', NULL, 'techplan.ksv.pa' , 'ptNUMERIC', 0, true, 'kw') ON CONFLICT DO NOTHING;
        INSERT INTO recnogroup (reg_tablename, reg_gruppe, reg_bez, reg_bez_textno, reg_pname, reg_paramtype, reg_default, reg_autoinsert, reg_m_iso ) VALUES
            ('ksv', 'TechPlan', 'Wirkungsgrad'     , NULL, 'techplan.ksv.w'  , 'ptNUMERIC', 0, true, NULL) ON CONFLICT DO NOTHING;
        INSERT INTO recnogroup (reg_tablename, reg_gruppe, reg_bez, reg_bez_textno, reg_pname, reg_paramtype, reg_default, reg_autoinsert, reg_m_iso ) VALUES
            ('ksv', 'TechPlan', 'Standby-Zeit'     , NULL, 'techplan.ksv.tsb', 'ptNUMERIC', 0, true, 'h')  ON CONFLICT DO NOTHING;


-- Lohnarten definieren für Datev-Export , Addison Export läuft aktuell nicht über die Lohnarten-Tabelle.
-- Lohnarten
INSERT INTO lohnarten
    (loa_id, loa_nr, loa_bez,                       loa_entgeltgruppen,      loa_prio, loa_is_default, loa_uebersteuert_weitere_la)
VALUES
    (1,      1000, 'Stundenlohn',                   'LOHN',                  1,        true,           true),
    (2,     -1000, 'Stundenlohn',                   'LOHNF,AZUBI',           1,        true,           true),
    (3,     -1000, 'Stundenlohn',                   'GEHA',                  1,        true,           true),
    (4,      1203, 'Spätschicht 10% stpfl',         'LOHN,LOHNF,AZUBI',      2,        false,          true),
    (5,      1500, 'Nachtzuschlag 25% stfr',        'LOHN,LOHNF,AZUBI',      3,        false,          false),
    (6,      1501, 'Nachtzuschlag 40% stfr',        'LOHN,LOHNF,AZUBI',      4,        false,          false),
    (7,      1530, 'Früh/Spät 25% stfr',            'LOHN,LOHNF,AZUBI',      5,        false,          false),
    (8,      1521, 'Spätschicht 10% stfr',          'LOHN,LOHNF,AZUBI',      6,        false,          false),
    (9,      1013, 'Feiertag',                      'LOHN,LOHNF,AZUBI',      7,        false,          false),
    (10,     1650, 'Krank',                         'LOHN,LOHNF,AZUBI,GEHA', 8,        false,          false),
    (11,     1600, 'Urlaub',                        'LOHN,LOHNF,AZUBI,GEHA', 9,        false,          false),
    (12,     3890, 'Einmalbezug',                   'LOHN,LOHNF,AZUBI,GEHA', 9,        false,          false),
    (13,     9998, 'Elternzeit',                    'LOHN,LOHNF,AZUBI,GEHA', 9,        false,          false),
    (14,     9999, 'Mutterschutz',                  'LOHN,LOHNF,AZUBI,GEHA', 9,        false,          false),
    (15,     9997, 'Pflege krankes Kind',           'LOHN,LOHNF,AZUBI,GEHA', 9,        false,          false),
    (16,     1100, 'Überstundenauszahlung',         'LOHN,LOHNF,AZUBI,GEHA', 10,       false,          false),
    (17,     1200, 'Überstundenzuschlag 25% stpfl', 'LOHN,LOHNF,AZUBI',      12,       false,          false),
    (18,     4060, 'Urlaubsauszahlung',             'LOHN,LOHNF,AZUBI,GEHA', 11,       false,          false)
ON CONFLICT DO NOTHING;

SELECT setval('lohnarten_loa_id_seq', 30, false);

-- Setting bzgl. der zu exportierenden Entgeltgruppe(n), sodass diese vom Kunden gesteuert werden können.
-- kommasepariertes Enum, z.B. 'LOHN,LOHNF'
-- siehe Settings/BDE/DATEV Entgeltgruppe(n)
SELECT TSystem.Settings__Set( 'BDE.LohnUndGehalt.Export.Datev_Force_Stundenexport', 'LOHN' );


-- Zeiten in denen diese Lohnarten genutzt werden können. aktuell Kreyenberg-spezifisch
INSERT INTO lohnarten_zeiten
    (loaz_laid, loaz_starttime, loaz_endtime, loaz_starttime_spread, loaz_endtime_spread, loaz_is_monday, loaz_is_tuesday, loaz_is_wednesday, loaz_is_thursday, loaz_is_friday , loaz_is_saturday, loaz_is_sunday, loaz_is_holiday, loaz_is_default)
VALUES
    (1,         '06:00:00',     '14:00:00',   '03:00:00',            '15:00:00',          true,           true,            true,              true,             true,            true,             true,           false,           true),
    (2,         '06:00:00',     '14:00:00',   '03:00:00',            '15:00:00',          true,           true,            true,              true,             true,            true,             true,           false,           true),
    (3,         '06:00:00',     '14:00:00',   '00:00:00',            '23:59:00',          true,           true,            true,              true,             true,            true,             true,           false,           true),
    (4,         '14:00:00',     '20:00:00',   '11:50:00',            '23:59:00',          true,           true,            true,              true,             true,            true,             true,           false,           true),
    (5,         '20:00:00',     '00:00:00',   null,                  null,                true,           true,            true,              true,             true,            true,             true,           false,           true),
    (5,         '04:00:00',     '06:00:00',   null,                  null,                true,           true,            true,              true,             true,            true,             true,           false,           true),
    (6,         '00:00:00',     '04:00:00',   null,                  null,                true,           true,            true,              true,             true,            true,             true,           false,           true)
ON CONFLICT DO NOTHING;

SELECT setval('lohnarten_zeiten_loaz_id_seq', 15, false);
-------

--- #17927 Prüfmittel Prüfart von hardcode auf Vorgabeliste umstellen
  INSERT INTO recnogroup( reg_tablename, reg_gruppe_textno, reg_pos, reg_bez_textno, reg_paramtype, reg_pname      , reg_exclusive, reg_autoinsert, reg_visible)
  SELECT 'artinventar', 26456, 70, 4471, 'ptENUM', 'artpr.pr_part', true, false, true
  WHERE NOT EXISTS (SELECT true FROM recnogroup WHERE reg_tablename = 'artinventar');

  INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
  SELECT 'artpr.pr_part', '1', 'wird durch externes Labor kalibriert'           , 1 WHERE NOT EXISTS ( SELECT true FROM recnoenums WHERE rege_reg_pname = 'artpr.pr_part' AND rege_code = '1' );

  INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
  SELECT 'artpr.pr_part', '2', 'wird intern auf Funktion / Beschädigung geprüft', 2 WHERE NOT EXISTS ( SELECT true FROM recnoenums WHERE rege_reg_pname = 'artpr.pr_part' AND rege_code = '2' );

  INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
  SELECT 'artpr.pr_part', '3', 'wird intern mit Prüfnormalen kalibriert'        , 3 WHERE NOT EXISTS ( SELECT true FROM recnoenums WHERE rege_reg_pname = 'artpr.pr_part' AND rege_code = '3' );

  INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
  SELECT 'artpr.pr_part', '4', 'unterliegt einem Wartungsvertrag'               , 4 WHERE NOT EXISTS ( SELECT true FROM recnoenums WHERE rege_reg_pname = 'artpr.pr_part' AND rege_code = '4' );

  INSERT INTO recnoenums(rege_reg_pname, rege_code, rege_bez, rege_pos)
  SELECT 'artpr.pr_part', '5', 'wird intern nach Wartungsplan gewartet'         , 5 WHERE NOT EXISTS ( SELECT true FROM recnoenums WHERE rege_reg_pname = 'artpr.pr_part' AND rege_code = '5' );
---

-- #18133 Kommissionslagerorte für Chargenrestmengen
-- #23449 Vorgabewert = true für Vorgabewerte ksv.lager.restmenge und art.lager.restmenge
INSERT INTO recnogroup
  ( reg_tablename, reg_gruppe, reg_bez, reg_bez_textno, reg_pname, reg_paramtype, reg_default )
VALUES
  ('ksv', 'System', 'Kostenstelle lagert Restmenge in Kommissionierlagerort', 35141, 'ksv.lager.restmenge' , 'ptBOOLEAN', true )
ON CONFLICT DO NOTHING;

INSERT INTO recnogroup
  ( reg_tablename, reg_gruppe, reg_bez, reg_bez_textno, reg_pname, reg_paramtype, reg_default )
VALUES
  ('art', 'System', 'Artikel lagert Restmenge in Kommissionierlagerort', 35140, 'art.lager.restmenge' , 'ptBOOLEAN', false )
ON CONFLICT DO NOTHING;
--

-- Vorgaben für die Prüfmittelverwaltung -> Messmittelgruppen (#19012)
INSERT INTO recnogroup( reg_schema, reg_tablename, reg_gruppe_textno, reg_pos, reg_bez_textno, reg_paramtype,      reg_pname, reg_exclusive, reg_autoinsert, reg_visible )
                VALUES( null      , 'artinventar', 26456            ,      80,          29855,      'ptENUM', 'artpr.pr_kat',          true,          false, true        );

CREATE SEQUENCE seq_rege_pos START 10 INCREMENT 10;

INSERT INTO recnoenums( rege_reg_pname, rege_code, rege_bez, rege_pos )
   VALUES             ( 'artpr.pr_kat', 'AC', 'Peilkompass'        , nextval('seq_rege_pos') ),
                      ( 'artpr.pr_kat', 'AN', 'Winkel'             , nextval('seq_rege_pos') ),
                      ( 'artpr.pr_kat', 'CR', 'Crimpwerkzeuge'     , nextval('seq_rege_pos') ),
                      ( 'artpr.pr_kat', 'EL', 'Elektrische Größen' , nextval('seq_rege_pos') ),
                      ( 'artpr.pr_kat', 'FO', 'Kraft'              , nextval('seq_rege_pos') ),
                      ( 'artpr.pr_kat', 'LE', 'Längen'             , nextval('seq_rege_pos') ),
                      ( 'artpr.pr_kat', 'MA', 'Massen'             , nextval('seq_rege_pos') ),
                      ( 'artpr.pr_kat', 'MI', 'Deverse Messgeräten', nextval('seq_rege_pos') ),
                      ( 'artpr.pr_kat', 'PR', 'Druck'              , nextval('seq_rege_pos') ),
                      ( 'artpr.pr_kat', 'TE', 'Temperaturen'       , nextval('seq_rege_pos') ),
                      ( 'artpr.pr_kat', 'TI', 'Zeit'               , nextval('seq_rege_pos') ),
                      ( 'artpr.pr_kat', 'TO', 'Drehmomint'         , nextval('seq_rege_pos') );
DROP SEQUENCE IF EXISTS seq_rege_pos;


-- #17854 Vorgaben für Farben und Textstile für die Oberfläche
INSERT INTO tsystem.cim_font_colors
  ( cfc_kontext, cfc_index,             cfc_color_argb, cfc_color_bez, cfc_font_bold, cfc_font_italic, cfc_font_underline, cfc_font_strikeout )
VALUES
  ( 'Plantafel',        -1, hex_to_integer( '1E94A8' ),    'Blaugrau',          null,            true,               null,               null ),
  ( 'Plantafel',         1,                       null,          null,          true,            true,               null,               null ),
  ( 'Plantafel',        10, hex_to_integer( '0500FA' ),  'CimDarkRed',          true,            true,               null,               null ),
  ( 'Plantafel',         2, hex_to_integer( '0600FF' ),      'Indigo',          null,            null,               null,               null ),
  ( 'Plantafel',         3, hex_to_integer( '00B000' ),        'Grün',          null,            null,               null,               null ),
  ( 'Plantafel',         4, hex_to_integer( 'B3B300' ),        'Blau',          null,            null,               null,               null ),
  ( 'Plantafel',         5, hex_to_integer( 'FF00FF' ),   'clFuchsia',          null,            null,               null,               null ),
  ( 'Plantafel',         6, hex_to_integer( '187C8D' ),       'Braun',          null,            null,               null,               null ),
  ( 'Plantafel',         7, hex_to_integer( 'B08A66' ),  'Dunkelblau',          null,            null,               null,               null ),
  ( 'Plantafel',         8, hex_to_integer( 'C8C8C8' ),        'Grau',          null,            null,               null,               null );
--

--- #21892 Messmaschinen Dokumente import Protokolle
INSERT INTO dokverwaltung (dv_showname, dv_tablename, dv_filepath, dv_savepath, dv_keyfields, dv_fileschema, dv_sqlstring, dv_standdok, dv_doktype, dv_recursive, dv_onlyaslink, dv_maxfileage, dv_sqlupdate, dv_config)
VALUES ('Protokolle extern', 'ldsdoktxt', E'X:\\Path', 'Messprotokolle - Extern', 'BestNr', 'ABKB[BestNr]_*.*',
      'SELECT ld_code,ld_auftg,ld_pos,ld_aknr, ld_kn,ld_term
FROM
 ldsdoktxt JOIN ldsdok ON (ldt_auftg = ld_auftg AND ldt_code = ld_code)
WHERE ldt_code = ''E'' AND ldt_auftg LIKE :BestNr', false, 'q_messprot', true, false, NULL, NULL, NULL);

INSERT INTO dokverwaltung (dv_showname, dv_tablename, dv_filepath, dv_savepath, dv_keyfields, dv_fileschema, dv_sqlstring, dv_standdok, dv_doktype, dv_recursive, dv_onlyaslink, dv_maxfileage, dv_sqlupdate, dv_config)
  VALUES ('Protokolle intern', 'abk', E'X:\\Path', 'Messprotokolle - Intern', 'ABKIndex', 'ABK[ABKIndex]_*.*',
      'SELECT ab_ix, ld_aknr, ak_bez, ld_stk
FROM abk
  JOIN ldsdok ON (ld_abk = ab_ix )
  JOIN art ON ld_aknr = ak_nr
WHERE ab_ix LIKE :ABKIndex', false, 'q_messprot', true, false, NULL, NULL, NULL);
---

--- #23020
INSERT INTO warengruppe ( wgr_kurzname, wgr_bez, wgr_id_intern, wgr_id_extern, wgr_gr1, wgr_gr2, wgr_gr3, wgr_gr4, wgr_gr5, wgr_beschreibung, wgr_verantwortl, wgr_is_einkauf, wgr_is_verkauf )
 VALUES
('W010.000', NULL, NULL, NULL, 'W', 'Werkzeuge', 'Fräswerkzeug', 'n.d.', NULL, NULL, NULL, true, false),
('W020.000', NULL, NULL, NULL, 'W', 'Werkzeuge', 'Drehwerkzeug', 'n.d.', NULL, NULL, NULL, true, false),
('W030.000', NULL, NULL, NULL, 'W', 'Werkzeuge', 'Handwerkzeug', 'n.d.', NULL, NULL, NULL, true, false),
('W040.000', NULL, NULL, NULL, 'W', 'Werkzeuge', 'Bohrer', 'n.d.', NULL, NULL, NULL, true, false),
('W050.000', NULL, NULL, NULL, 'W', 'Werkzeuge', 'Werkzeughalter Drehen', 'n.d.', NULL, NULL, NULL, true, false),
('W070.000', NULL, NULL, NULL, 'W', 'Werkzeuge', 'Elektrowerkzeug', 'n.d.', NULL, NULL, NULL, true, false),
('W080.000', NULL, NULL, NULL, 'W', 'Werkzeuge', 'Spritzgusswerkzeug', 'n.d.', NULL, NULL, NULL, true, false),
('W090.000', NULL, NULL, NULL, 'W', 'Werkzeuge', 'Messmittel', 'n.d.', NULL, NULL, NULL, true, false),
('W100.000', NULL, NULL, NULL, 'W', 'Werkzeuge', 'Messgerät', 'n.d.', NULL, NULL, NULL, true, false),
('H010.000', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Alu', 'n.d.', NULL, NULL, NULL, true, false),
('H010.010', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Alu', 'Platten', NULL, NULL, NULL, true, false),
('H010.020', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Alu', 'Stangen', NULL, NULL, NULL, true, false),
('H010.030', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Alu', 'Zuschnitte', NULL, NULL, NULL, true, false),
('H010.040', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Alu', 'Bleche', NULL, NULL, NULL, true, false),
('H010.050', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Alu', 'Profile', NULL, NULL, NULL, true, false),
('H020.000', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Stahl/Edelstahl', 'n.d.', NULL, NULL, NULL, true, false),
('H020.010', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Stahl/Edelstahl', 'Platten', NULL, NULL, NULL, true, false),
('H020.020', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Stahl/Edelstahl', 'Stangen', NULL, NULL, NULL, true, false),
('H020.030', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Stahl/Edelstahl', 'Zuschnitte', NULL, NULL, NULL, true, false),
('H020.040', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Stahl/Edelstahl', 'Bleche', NULL, NULL, NULL, true, false),
('H020.050', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Stahl/Edelstahl', 'Profile', NULL, NULL, NULL, true, false),
('H030.000', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Titan', 'n.d.', NULL, NULL, NULL, true, false),
('H030.010', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Titan', 'Platten', NULL, NULL, NULL, true, false),
('H030.020', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Titan', 'Stangen', NULL, NULL, NULL, true, false),
('H030.030', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Titan', 'Zuschnitte', NULL, NULL, NULL, true, false),
('H030.040', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Titan', 'Bleche', NULL, NULL, NULL, true, false),
('H030.050', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Titan', 'Profile', NULL, NULL, NULL, true, false),
('H040.000', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Buntmetall', 'n.d.', NULL, NULL, NULL, true, false),
('H040.010', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Buntmetall', 'Platten', NULL, NULL, NULL, true, false),
('H040.020', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Buntmetall', 'Stangen', NULL, NULL, NULL, true, false),
('H040.030', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Buntmetall', 'Zuschnitte', NULL, NULL, NULL, true, false),
('H040.040', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Buntmetall', 'Bleche', NULL, NULL, NULL, true, false),
('H040.050', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Buntmetall', 'Profile', NULL, NULL, NULL, true, false),
('H050.000', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Kunststoff', 'n.d.', NULL, NULL, NULL, true, false),
('H050.010', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Kunststoff', 'Platten', NULL, NULL, NULL, true, false),
('H050.020', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Kunststoff', 'Stangen', NULL, NULL, NULL, true, false),
('H050.030', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Kunststoff', 'Zuschnitte', NULL, NULL, NULL, true, false),
('H050.050', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Kunststoff', 'Profile', NULL, NULL, NULL, true, false),
('H060.000', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Sondermaterial', 'n.d.', NULL, NULL, NULL, true, false),
('H060.010', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Sondermaterial', 'Platten', NULL, NULL, NULL, true, false),
('H060.020', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Sondermaterial', 'Stangen', NULL, NULL, NULL, true, false),
('H060.030', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Sondermaterial', 'Zuschnitte', NULL, NULL, NULL, true, false),
('H060.040', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Sondermaterial', 'Bleche', NULL, NULL, NULL, true, false),
('H060.050', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Sondermaterial', 'Profile', NULL, NULL, NULL, true, false),
('H070.000', NULL, NULL, NULL, 'H', 'Halbzeuge', 'Ferrite', 'n.d.', NULL, NULL, NULL, true, false),
('E020.000', NULL, NULL, NULL, 'E', 'Elektro / Elektronikkomponenten', 'Kabel / Kabelmanagement', 'n.d.', NULL, NULL, NULL, true, false),
('E030.000', NULL, NULL, NULL, 'E', 'Elektro / Elektronikkomponenten', 'Stecker', 'n.d.', NULL, NULL, NULL, true, false),
('E040.000', NULL, NULL, NULL, 'E', 'Elektro / Elektronikkomponenten', 'Motoren', 'n.d.', NULL, NULL, NULL, true, false),
('E060.000', NULL, NULL, NULL, 'E', 'Elektro / Elektronikkomponenten', 'Displays', 'n.d.', NULL, NULL, NULL, true, false),
('E080.000', NULL, NULL, NULL, 'E', 'Elektro / Elektronikkomponenten', 'Schrumpfschlauch', 'n.d.', NULL, NULL, NULL, true, false),
('E090.000', NULL, NULL, NULL, 'E', 'Elektro / Elektronikkomponenten', 'Leuchtmittel', 'n.d.', NULL, NULL, NULL, true, false),
('N010.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Schrauben', 'n.d.', NULL, NULL, NULL, true, false),
('N010.010', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Schrauben', 'Sonder', NULL, NULL, NULL, true, false),
('N020.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Muttern', 'n.d.', NULL, NULL, NULL, true, false),
('N020.010', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Muttern', 'Sonder', NULL, NULL, NULL, true, false),
('N030.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Scheiben', 'n.d.', NULL, NULL, NULL, true, false),
('N030.010', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Scheiben', 'Sonder', NULL, NULL, NULL, true, false),
('N040.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Gewindeeinsätze', 'n.d.', NULL, NULL, NULL, true, false),
('N040.010', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Gewindeeinsätze', 'Sonder', NULL, NULL, NULL, true, false),
('N050.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Buchsen', 'n.d.', NULL, NULL, NULL, true, false),
('N050.010', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Buchsen', 'Sonder', NULL, NULL, NULL, true, false),
('N060.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Federn', 'n.d.', NULL, NULL, NULL, true, false),
('N060.010', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Federn', 'Sonder', NULL, NULL, NULL, true, false),
('N080.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Spannmittel', 'n.d.', NULL, NULL, NULL, true, false),
('N080.010', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Spannmittel', 'Sonder', NULL, NULL, NULL, true, false),
('N100.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Magnete', 'n.d.', NULL, NULL, NULL, true, false),
('N100.010', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Magnete', 'Sonder', NULL, NULL, NULL, true, false),
('S010.000', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Schutzbrille', 'n.d.', NULL, NULL, NULL, true, false),
('S020.000', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Schutzhandschuhe', 'n.d.', NULL, NULL, NULL, true, false),
('S020.010', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Schutzhandschuhe', 'ESD', NULL, NULL, NULL, true, false),
('S030.000', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', '1. Hilfe / Verbandszeug', 'n.d.', NULL, NULL, NULL, true, false),
('S040.000', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Kleidung', 'n.d.', NULL, NULL, NULL, true, false),
('S040.010', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Kleidung', 'ESD', NULL, NULL, NULL, true, false),
('S040.020', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Kleidung', 'Arbeitskleidung', NULL, NULL, NULL, true, false),
('N070.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Lagertechnik (Wälz- Kugel- und Gleitlager)', 'n.d.', NULL, NULL, NULL, true, false),
('E010.000', NULL, NULL, NULL, 'E', 'Elektro / Elektronikkomponenten', 'SMD-Bauteile/Regler', 'n.d.', NULL, NULL, NULL, true, false),
('E050.000', NULL, NULL, NULL, 'E', 'Elektro / Elektronikkomponenten', 'Sensorik/Taster/Schalter', 'n.d.', NULL, NULL, NULL, true, false),
('W060.000', NULL, NULL, NULL, 'W', 'Werkzeuge', 'Werkzeughalter Fräsen', 'n.d.', NULL, NULL, NULL, true, false),
('S050.000', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Atemschutz', 'n.d.', NULL, NULL, NULL, true, false),
('S060.000', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Gehörschutz', 'n.d.', NULL, NULL, NULL, true, false),
('S070.000', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Warnhinweise - / zeichen', 'n.d.', NULL, NULL, NULL, true, false),
('S080.000', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Schuhe', 'n.d.', NULL, NULL, NULL, true, false),
('S080.010', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Schuhe', 'ESD', NULL, NULL, NULL, true, false),
('S080.020', NULL, NULL, NULL, 'S', 'Schutzkleidung /PSA', 'Schuhe', 'Arbeitskleidung', NULL, NULL, NULL, true, false),
('D010.000', NULL, NULL, NULL, 'D', 'Dienstleistungen', 'Kalibrierservice', 'n.d.', NULL, NULL, NULL, true, false),
('D020.000', NULL, NULL, NULL, 'D', 'Dienstleistungen', 'Wartung/Instandhaltung', 'n.d.', NULL, NULL, NULL, true, false),
('D030.000', NULL, NULL, NULL, 'D', 'Dienstleistungen', 'Reinigung', 'n.d.', NULL, NULL, NULL, true, false),
('D040.000', NULL, NULL, NULL, 'D', 'Dienstleistungen', 'Versanddienstleistung', 'n.d.', NULL, NULL, NULL, true, false),
('D050.000', NULL, NULL, NULL, 'D', 'Dienstleistungen', 'Werkzeugschleifen', 'n.d.', NULL, NULL, NULL, true, false),
('D060.000', NULL, NULL, NULL, 'D', 'Dienstleistungen', 'IT', 'n.d.', NULL, NULL, NULL, true, false),
('D070.000', NULL, NULL, NULL, 'D', 'Dienstleistungen', 'Zertifizierung', 'n.d.', NULL, NULL, NULL, true, false),
('D080.000', NULL, NULL, NULL, 'D', 'Dienstleistungen', 'Sicherheitsabnahme', 'n.d.', NULL, NULL, NULL, true, false),
('D090.000', NULL, NULL, NULL, 'D', 'Dienstleistungen', 'Analysen', 'n.d.', NULL, NULL, NULL, true, false),
('D100.000', NULL, NULL, NULL, 'D', 'Dienstleistungen', 'Beratung/Coaching', 'n.d.', NULL, NULL, NULL, true, false),
('K010.000', NULL, NULL, NULL, 'K', 'Kundenbeistellung', 'Halbzeuge', 'n.d.', NULL, NULL, NULL, true, false),
('K020.000', NULL, NULL, NULL, 'K', 'Kundenbeistellung', 'Zeichnungsteile ext. / Produktionsteile', 'n.d.', NULL, NULL, NULL, true, false),
('K030.000', NULL, NULL, NULL, 'K', 'Kundenbeistellung', 'Elektronikkomponenten', 'n.d.', NULL, NULL, NULL, true, false),
('K040.000', NULL, NULL, NULL, 'K', 'Kundenbeistellung', 'Normteile/Befestigungsmittel', 'n.d.', NULL, NULL, NULL, true, false),
('K050.000', NULL, NULL, NULL, 'K', 'Kundenbeistellung', 'Verbrauchsmaterial', 'n.d.', NULL, NULL, NULL, true, false),
('K070.000', NULL, NULL, NULL, 'K', 'Kundenbeistellung', 'Verpackungen', 'n.d.', NULL, NULL, NULL, true, false),
('Z010.000', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Drehteile', 'n.d.', NULL, NULL, NULL, true, false),
('Z010.010', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Drehteile', 'Alu', NULL, NULL, NULL, true, false),
('Z010.020', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Drehteile', 'Stahl', NULL, NULL, NULL, true, false),
('Z010.030', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Drehteile', 'Titan', NULL, NULL, NULL, true, false),
('Z010.040', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Drehteile', 'Kupfer', NULL, NULL, NULL, true, false),
('Z010.050', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Drehteile', 'Kunststoff', NULL, NULL, NULL, true, false),
('Z010.060', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Drehteile', 'Sondermaterial', NULL, NULL, NULL, true, false),
('Z020.000', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Frästeile', 'n.d.', NULL, NULL, NULL, true, false),
('Z020.010', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Frästeile', 'Alu', NULL, NULL, NULL, true, false),
('Z020.020', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Frästeile', 'Stahl', NULL, NULL, NULL, true, false),
('Z020.030', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Frästeile', 'Titan', NULL, NULL, NULL, true, false),
('Z020.040', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Frästeile', 'Kupfer', NULL, NULL, NULL, true, false),
('Z020.050', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Frästeile', 'Kunststoff', NULL, NULL, NULL, true, false),
('Z020.060', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Frästeile', 'Sondermaterial', NULL, NULL, NULL, true, false),
('Z030.000', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Dreh-/Frästeile', 'n.d.', NULL, NULL, NULL, true, false),
('Z030.010', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Dreh-/Frästeile', 'Alu', NULL, NULL, NULL, true, false),
('Z030.020', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Dreh-/Frästeile', 'Stahl', NULL, NULL, NULL, true, false),
('Z030.030', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Dreh-/Frästeile', 'Titan', NULL, NULL, NULL, true, false),
('Z030.040', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Dreh-/Frästeile', 'Kupfer', NULL, NULL, NULL, true, false),
('Z030.050', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Dreh-/Frästeile', 'Kunststoff', NULL, NULL, NULL, true, false),
('Z030.060', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Dreh-/Frästeile', 'Sondermaterial', NULL, NULL, NULL, true, false),
('Z040.000', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Additive Bauteile', 'n.d.', NULL, NULL, NULL, true, false),
('Z040.010', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Additive Bauteile', 'Alu', NULL, NULL, NULL, true, false),
('Z040.020', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Additive Bauteile', 'Stahl', NULL, NULL, NULL, true, false),
('Z040.050', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Additive Bauteile', 'Kunststoff', NULL, NULL, NULL, true, false),
('Z040.060', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Additive Bauteile', 'Sondermaterial', NULL, NULL, NULL, true, false),
('Z050.000', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Blechteile', 'n.d.', NULL, NULL, NULL, true, false),
('Z050.010', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Blechteile', 'Alu', NULL, NULL, NULL, true, false),
('Z050.020', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Blechteile', 'Stahl', NULL, NULL, NULL, true, false),
('Z050.030', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Blechteile', 'Titan', NULL, NULL, NULL, true, false),
('Z050.040', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Blechteile', 'Kupfer', NULL, NULL, NULL, true, false),
('Z050.060', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Blechteile', 'Sondermaterial', NULL, NULL, NULL, true, false),
('Z060.000', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Guss-/Spritzgussteile', 'n.d.', NULL, NULL, NULL, true, false),
('Z060.010', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Guss-/Spritzgussteile', 'Alu', NULL, NULL, NULL, true, false),
('Z060.020', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Guss-/Spritzgussteile', 'Stahl', NULL, NULL, NULL, true, false),
('Z060.050', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Guss-/Spritzgussteile', 'Kunststoff', NULL, NULL, NULL, true, false),
('Z060.060', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Guss-/Spritzgussteile', 'Sondermaterial', NULL, NULL, NULL, true, false),
('Z070.000', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Elektro', 'n.d.', NULL, NULL, NULL, true, false),
('Z070.070', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Elektro', 'Kabelkonfektionierung', NULL, NULL, NULL, true, false),
('Z070.080', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Elektro', 'Platinenbestäckung', NULL, NULL, NULL, true, false),
('Z080.000', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Baugruppe', 'n.d.', NULL, NULL, NULL, true, false),
('K060.000', NULL, NULL, NULL, 'K', 'Kundenbeistellung', 'Prüf / Messmittel', 'n.d.', NULL, NULL, NULL, true, false),
('B010.020', NULL, NULL, NULL, 'B', 'Büroeinrichtung / Betriebsausstattung', 'IT-Bedarf', 'Hardware', NULL, NULL, NULL, true, false),
('Z090.000', NULL, NULL, NULL, 'Z', 'Zeichnungsteile  ext. /Produktionsteile', 'Aufkleber / Schilder', 'n.d.', NULL, NULL, NULL, true, false),
('V010.000', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'KSS', 'n.d.', NULL, NULL, NULL, true, false),
('V020.000', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'Klebstoffe', 'n.d.', NULL, NULL, NULL, true, false),
('V020.010', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'Klebstoffe', 'Schraubensicherung', NULL, NULL, NULL, true, false),
('V030.000', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'Öle/Fette', 'n.d.', NULL, NULL, NULL, true, false),
('V040.000', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'Reiniger', 'n.d.', NULL, NULL, NULL, true, false),
('V050.000', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'Hygieneartikel', 'n.d.', NULL, NULL, NULL, true, false),
('V060.000', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'Tücher', 'n.d.', NULL, NULL, NULL, true, false),
('V070.000', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'Chemikalien', 'n.d.', NULL, NULL, NULL, true, false),
('F010.000', NULL, NULL, NULL, 'F', 'Fortbildung/Marketing', 'Normen', 'n.d.', NULL, NULL, NULL, true, false),
('F020.000', NULL, NULL, NULL, 'F', 'Fortbildung/Marketing', 'Bücher', 'n.d.', NULL, NULL, NULL, true, false),
('F030.000', NULL, NULL, NULL, 'F', 'Fortbildung/Marketing', 'Zeitschriften', 'n.d.', NULL, NULL, NULL, true, false),
('F040.000', NULL, NULL, NULL, 'F', 'Fortbildung/Marketing', 'Schulungen', 'n.d.', NULL, NULL, NULL, true, false),
('F050.000', NULL, NULL, NULL, 'F', 'Fortbildung/Marketing', 'Werbung', 'n.d.', NULL, NULL, NULL, true, false),
('F060.000', NULL, NULL, NULL, 'F', 'Fortbildung/Marketing', 'Messebedarf', 'n.d.', NULL, NULL, NULL, true, false),
('P010.000', ' ', NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Kartonagen', 'n.d.', NULL, NULL, NULL, true, false),
('P020.000', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Zwischenlage', 'n.d.', NULL, NULL, NULL, true, false),
('P020.010', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Zwischenlage', 'Papier/Pappe', NULL, NULL, NULL, true, false),
('P030.000', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Klebeband', 'n.d.', NULL, NULL, NULL, true, false),
('P040.000', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Folie', 'n.d.', NULL, NULL, NULL, true, false),
('P040.050', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Folie', 'VCI/Korrosionsschutz', NULL, NULL, NULL, true, false),
('P040.060', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Folie', 'ESD', NULL, NULL, NULL, true, false),
('P050.000', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Füllmaterial', 'n.d.', NULL, NULL, NULL, true, false),
('P060.000', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Kisten / Boxen /Deckel', 'n.d.', NULL, NULL, NULL, true, false),
('P060.020', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Kisten / Boxen /Deckel', 'Kunststoff', NULL, NULL, NULL, true, false),
('P060.030', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Kisten / Boxen /Deckel', 'Holz', NULL, NULL, NULL, true, false),
('P060.040', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Kisten / Boxen /Deckel', 'Stahl', NULL, NULL, NULL, true, false),
('P060.050', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Kisten / Boxen /Deckel', 'VCI/Korrosionsschutz', NULL, NULL, NULL, true, false),
('P060.060', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Kisten / Boxen /Deckel', 'ESD', NULL, NULL, NULL, true, false),
('P070.000', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Facheinsätze', 'n.d.', NULL, NULL, NULL, true, false),
('P070.010', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Facheinsätze', 'Papier/Pappe', NULL, NULL, NULL, true, false),
('P070.020', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Facheinsätze', 'Kunststoff', NULL, NULL, NULL, true, false),
('P070.030', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Facheinsätze', 'Holz', NULL, NULL, NULL, true, false),
('P070.060', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Facheinsätze', 'ESD', NULL, NULL, NULL, true, false),
('P080.000', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Kanister / Behälter', 'n.d.', NULL, NULL, NULL, true, false),
('P080.020', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Kanister / Behälter', 'Kunststoff', NULL, NULL, NULL, true, false),
('P090.000', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Umreifungsband', 'n.d.', NULL, NULL, NULL, true, false),
('P100.000', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Paletten', 'n.d.', NULL, NULL, NULL, true, false),
('P100.010', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Paletten', 'Papier/Pappe', NULL, NULL, NULL, true, false),
('P100.020', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Paletten', 'Kunststoff', NULL, NULL, NULL, true, false),
('P100.030', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Paletten', 'Holz', NULL, NULL, NULL, true, false),
('L010.000', NULL, NULL, NULL, 'L', 'Luft- und Fluidtechnik / Rohrleitungstechnik', 'Pneumatik', 'n.d.', NULL, NULL, NULL, true, false),
('L020.000', NULL, NULL, NULL, 'L', 'Luft- und Fluidtechnik / Rohrleitungstechnik', 'Hydraulik', 'n.d.', NULL, NULL, NULL, true, false),
('M010.000', NULL, NULL, NULL, 'M', 'Maschinen und Apparate / Flurförderfahrzeuge', 'Drehmaschinen', 'n.d.', NULL, NULL, NULL, true, false),
('M010.010', NULL, NULL, NULL, 'M', 'Maschinen und Apparate / Flurförderfahrzeuge', 'Drehmaschinen', 'Ersatzteile', NULL, NULL, NULL, true, false),
('M020.000', NULL, NULL, NULL, 'M', 'Maschinen und Apparate / Flurförderfahrzeuge', 'Fräsmaschine', 'n.d.', NULL, NULL, NULL, true, false),
('M020.010', NULL, NULL, NULL, 'M', 'Maschinen und Apparate / Flurförderfahrzeuge', 'Fräsmaschine', 'Ersatzteile', NULL, NULL, NULL, true, false),
('M030.000', NULL, NULL, NULL, 'M', 'Maschinen und Apparate / Flurförderfahrzeuge', 'Dreh-/Fräsmaschine', 'n.d.', NULL, NULL, NULL, true, false),
('M030.010', NULL, NULL, NULL, 'M', 'Maschinen und Apparate / Flurförderfahrzeuge', 'Dreh-/Fräsmaschine', 'Ersatzteile', NULL, NULL, NULL, true, false),
('M040.000', NULL, NULL, NULL, 'M', 'Maschinen und Apparate / Flurförderfahrzeuge', 'Erodiermaschine', 'n.d.', NULL, NULL, NULL, true, false),
('M040.010', NULL, NULL, NULL, 'M', 'Maschinen und Apparate / Flurförderfahrzeuge', 'Erodiermaschine', 'Ersatzteile', NULL, NULL, NULL, true, false),
('M050.000', NULL, NULL, NULL, 'M', 'Maschinen und Apparate / Flurförderfahrzeuge', 'Flurfördertechnik', 'n.d.', NULL, NULL, NULL, true, false),
('M050.010', NULL, NULL, NULL, 'M', 'Maschinen und Apparate / Flurförderfahrzeuge', 'Flurfördertechnik', 'Ersatzteile', NULL, NULL, NULL, true, false),
('B010.010', NULL, NULL, NULL, 'B', 'Büroeinrichtung / Betriebsausstattung', 'IT-Bedarf', 'Software', NULL, NULL, NULL, true, false),
('B030.000', NULL, NULL, NULL, 'B', 'Büroeinrichtung / Betriebsausstattung', 'Betriebs- und Geschäftsausstattung (BGA)', 'n.d.', NULL, NULL, NULL, true, false),
('B010.000', NULL, NULL, NULL, 'B', 'Büroeinrichtung / Betriebsausstattung', 'IT-Bedarf', 'n.d.', NULL, NULL, NULL, true, false),
('B020.000', NULL, NULL, NULL, 'B', 'Büroeinrichtung / Betriebsausstattung', 'Büromaterial', 'n.d.', NULL, NULL, NULL, true, false),
('N090.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Führung', 'n.d.', NULL, NULL, NULL, true, false),
('N090.010', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Führung', 'Sonder', NULL, NULL, NULL, true, false),
('V070.020', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'Chemikalien', 'Prüfmittel', NULL, NULL, NULL, true, false),
('N070.010', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Lagertechnik (Wälz- Kugel- und Gleitlager)', 'Sonder', NULL, NULL, NULL, true, false),
('E070.000', NULL, NULL, NULL, 'E', 'Elektro / Elektronikkomponenten', 'Haus-/Maschinenelektrik', 'n.d.', NULL, NULL, NULL, true, false),
('N110.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Dichtungstechnik', 'n.d.', NULL, NULL, NULL, true, NULL),
('N120.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Knäufe/ Hebel', 'n.d.', NULL, NULL, NULL, true, NULL),
('N130.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Sicherungselemente', 'n.d.', NULL, NULL, NULL, true, NULL),
('N140.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Zahnräder', 'n.d.', NULL, NULL, NULL, true, NULL),
('P110.000', NULL, NULL, NULL, 'P', 'Packmittel / Verpackungen', 'Hebetechnik      ', 'n.d.', NULL, NULL, NULL, true, NULL),
('V080.000', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'Batterien/Akkus', 'n.d.', NULL, NULL, NULL, true, NULL),
('V090.000', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'Etiketten', 'n.d.', NULL, NULL, NULL, true, NULL),
('V100.000', NULL, NULL, NULL, 'V', 'Verbrauchsmaterial', 'Filter', 'n.d.', NULL, NULL, NULL, true, NULL),
('N150.000', NULL, NULL, NULL, 'N', 'Normteile / Befestigungsmittel', 'Stifte/Gewindestifte', 'n.d.', NULL, NULL, NULL, true, NULL);
---
